// 让组件支持redux

import {bindActionCreators} from '../lib/redux/lib/index';
import {getStore} from '../utils/store';
import log from '../utils/log';
import {shouldUpdate} from '../utils/utils';

export default {
  reduxState: [],
  reduxDispatch: {},
  stateToProps(state) {
    const props = {};
    this.reduxState.forEach((item) => {
      props[item] = state[item];
    });
    return props;
  },
  redux: {},
  dispatchProps(dispatch) {
    return bindActionCreators(this.reduxDispatch, dispatch);
  },
  mergeProps(stateProps, dispatchProps, parentProps) {
    return Object.assign({}, parentProps, stateProps, dispatchProps);
  },
  clearDataTimer() {
    const pages = getCurrentPages();
    pages.forEach(page => {
      page.clearDataTimer();
    });
  },
  setDataTimer() {
    const pages = getCurrentPages();
    pages.forEach(page => {
      page.setDataTimer();
    });
  },
  propsToStateCompose: [

  ],
  propChanged(nextProp, preProp) {
    return typeof nextProp !== 'undefined' && nextProp !== preProp;
  },
  updateRedux(nextProps) {
    const newState = {};
    this.propsToStateCompose.forEach(setting => {
      if (setting.props.find(prop => this.propChanged(nextProps[prop], this.redux[prop]))) {
        setting.transform.bind(this)(nextProps, this.redux, newState);
      }
    });

    if (Object.keys(newState).length > 0) {
      this.setData(newState);
    }
  },
  stateChange() {
    // if (!this.visible) {
    //   return;
    // }
    let store = getStore();
    let mappedProps = this.stateToProps(store.getState());
    if (!shouldUpdate(this.redux, mappedProps)) {
      return;
    }
    let nextProps = this.mergeProps(mappedProps, this.dispatchProps(store.dispatch), this.redux);
    if (this.updateRedux) {
      this.clearDataTimer();
      this.updateRedux(nextProps);
      this.setDataTimer();
    }
    this.redux = nextProps;
  },
  onLoad(options) {
    let store = getStore();
    this.reduxUnSubscribe = store.subscribe(this.stateChange.bind(this));
    this.stateChange();
  },
  // onShow() {
  //   this.stateChange();
  // },
  onUnload() {
    if (this.reduxUnSubscribe) {
      this.reduxUnSubscribe();
    }
  }
}
