import { confirmFilter, updateFilter } from '../redux/filter';

import log from '../utils/log';

export default {
  reduxState: ['filter'],
  reduxDispatch: { confirmFilter, updateFilter },
  filter: {},
  data: {
    searchInput: ''
  },
  methods: {
    handleSearchInputChanged(e) {
      this.updateSearchInput(e.detail.value);
    }
  },
  updateSearchInput(text) {
    const pageId = this.getOption('pageId');
    if (pageId) {
      this.redux.updateFilter({ pageId, searchText: text, filter: {}, orgFilter: {} });
      this.redux.confirmFilter({ pageId });
    }
  },
  onLoad() {
    if (this.options.searchInput) {
      this.updateSearchInput(this.options.searchInput);
    }
  },
  updateRedux({ filter }) {
    const pageId = this.getOption('pageId');
    const theFilter = filter[pageId];
    if (theFilter && theFilter !== this.filter) {
      log('当前字段信息', pageId, theFilter);
      this.filter = theFilter;
      if (this.filter.error) {
        this.emit('showToptip', this.page, { icon: 'cancel', text: '更新搜索条件失败' });
      } else {
        this.setData({
          searchInput: this.filter.searchText
        });
      }
    }
  }
};
