import { fixImagePath } from '../../utils/utils';
import getPage from '../../module/page';
import { list } from '../../polaris/polaris';
import mixin from '../../utils/mixin';
import request from '../../config/request';
import viewpage from '../../module/viewpage';
import commonPage from '../../module/commonPage';

const ActivityMixin = mixin(commonPage,[{
  data: {
            url: ''
        },
  components: {
    list
  },
    methods: {
       moreButtonClicked(button) {

          console.log(button);
          this.initData();

      },

  },
  initData(){
    wx.getSystemInfo({
        success: (res) => {
            var windowHeight = res.windowHeight;
            this.setData({
                scrollHeight: windowHeight
            });
        }
    });

    const sections = [];

    let list = getApp.locationList;
    if (!list)  list =[];



    sections.push(
      {
        ID: 6,
        type: 'list-item',
        header: {
            type: 'header2',
            icon:' fa fa-star',
            title: '位置信息',
            class: 'b-b bg-white',
            decorate: true
        },
        items:  list.map(item => ({
                    primaryText : item.d,
                    secondaryText: '纬度:' + item.l.latitude,
                    tertiaryText: '经度:' +  item.l.longitude
                  })
              )
      });

      sections.push({
             ID: 'submit',
             type: 'button',
               items: [
                    {
                       id:'refresh',
                       primaryText: '刷新',
                    }
               ]


      });

      this.coms.list.updateItems(sections);



  },
  onLoad() {

      this.initData();

      },

}]);

Page(getPage(ActivityMixin, {
//  pageId: 152
}));
