import { comment, list } from '../../polaris/polaris';
import { fixImagePath, formatDate, removeHtml } from '../../utils/utils';

import fetchListMixin from '../../module/fetchListMixin';
import getPage from '../../module/page';
import mixin from '../../utils/mixin';
import regeneratorRuntime from '../../lib/regenerator-runtime/runtime';
import request from '../../config/request';
import viewpage from '../../module/viewpage';

const ViewDataMixin = mixin(viewpage, [
    fetchListMixin,
    {
        fetchListOnEnter: false,
        components: {
            list2: {
                component: list,
                options() {
                    return {
                        data: {
                            noFoot: true
                        }
                    };
                }
            },
            list: {
                component: list,
                options() {
                    return {
                        pageId: 34,
                        customModifyItem(item) {
                            item.section = {
                                ID: 5,
                                type: 'list-comment',
                                class: 'm-t-sm bg-white',
                                header: {
                                    type: 'header1',
                                    title: '用户评论',
                                    decorate: true,
                                    class: 'padder-t-md padder-b-sm'
                                }
                            };
                            item.user = item.__c52.XingMing;
                            item.time = formatDate(item.__c54, 'yyyy-MM-dd hh:mm:ss');
                            item.avatar =
                                'https://file3.bizsaas.com/files/2028/2017721/c263204f-d5de-45b6-a39c-cee4845b75f9.JPG';
                            item.content = removeHtml(item.__c53);
                        }
                    };
                }
            },
            comment: {
                component: comment,
                options() {
                    return {
                        sendComment: this.sendComment.bind(this)
                    };
                }
            }
        },
        afterDetailFetched() {
            const item = this.detailData.data;
            item.__c19 = removeHtml(item.__c19);

            const section = [];

            section.push({
                ID: 0,
                type: 'swiper',
                items: [
                    {
                        url: fixImagePath(item.__c20.FilePath)
                    }
                ]
            });

            section.push({
                ID: 1,
                type: 'list-item',
                class: 'padder-t-md',
                itemClass: 'no-border',
                items: [
                    {
                        primaryText: item.__c12,
                        primaryClass: 'text-xlg',
                        noNav: true
                    }
                ]
            });

            section.push({
                ID: 2,
                type: 'list-item',
                class: 'padder-t',
                items: [
                    {
                        icon: 'icon-clock',
                        primaryText: `时间: ${formatDate(item.__c13, 'yyyy.MM.dd')}-${formatDate(
                            item.__c14,
                            'yyyy.MM.dd'
                        )}`,
                        noNav: true
                    },
                    {
                        icon: 'icon-location-pin',
                        primaryText: `地点: ${item.__c15}`,
                        noNav: true
                    },
                    {
                        icon: 'icon-call-end',
                        primaryText: `电话: ${item.__c314}`,
                        noNav: true
                    }
                ]
            });

            const detail = [
                {
                    content: item.__c19
                }
            ];
            detail.push(...item.__c21.map((i) => ({ url: fixImagePath(i.FilePath) })));
            section.push({
                ID: 3,
                type: 'image-full',
                header: {
                    type: 'header2',
                    title: '活动详情',
                    class: 'b-b bg-white',
                    decorate: true
                },
                class: 'm-t-sm padder-b bg-white',
                itemClass: 'padder padder-t',
                items: detail
            });

            // section.push({
            //   ID: 4,
            //   type: 'list-image',
            //   imageLeft: true,
            //   class: 'm-t-sm bg-white',
            //   header: {
            //     type: 'header1',
            //     title: '相关推荐',
            //     decorate: true,
            //     class: 'padder-t-md padder-b-sm'
            //   },
            //   items: [
            //     {
            //       url: ['https://file3.bizsaas.com/files/2028/2017721/c263204f-d5de-45b6-a39c-cee4845b75f9.JPG'],
            //       primaryText: '一年一度最大优惠',
            //       primaryClass: 'text-l-2 text-sm',
            //       imageWrap: 'padder-r w-30-b',
            //       imageClass: 'medium-height',
            //       view: 30,
            //       comment: 30
            //     },
            //     {
            //       url: ['https://file3.bizsaas.com/files/2028/2017721/c263204f-d5de-45b6-a39c-cee4845b75f9.JPG'],
            //       primaryText: '一年一度最大优惠',
            //       primaryClass: 'text-l-2 text-sm',
            //       imageWrap: 'padder-r w-30-b',
            //       imageClass: 'medium-height',
            //       view: 30,
            //       comment: 30
            //     }]
            // });

            this.coms.list2.updateItems(section);

            this.coms.list.setFixedLsc([ { patternId: 55, val1: item.server_identity, pTypeId: 23, operation: 1 } ]);
        },
        sendComment(comment) {
            request.comment(this, {
                __c55: this.getData().item.server_identity,
                __c53: comment
            });
        },
        methods: {
            moreButtonClicked(button, item) {
                if (button.id === 'comment') {
                    this.coms.comment.setVisible();
                } else if (button.id === 'participate') {
                    this.itemNav({
                        pageId: 70,
                        params: {
                            item: {
                                __c125: this.getData().item.server_identity
                            }
                        }
                    });
                }
            }
        },
        updateButtons() {
            return [
                {
                    id: 'comment',
                    label: '评论',
                    icon: 'icon-speech'
                },
                {
                    id: 'participate',
                    label: '报名',
                    icon: 'icon-calendar'
                },
                {
                    id: 'share',
                    label: '分享',
                    icon: 'icon-share-alt'
                }
            ];
        }
    }
]);

Page(getPage(ViewDataMixin));
