import editpage from '../../module/editpage';
import getPage from '../../module/page';
import mixin from '../../utils/mixin';
import regeneratorRuntime from '../../lib/regenerator-runtime/runtime';
import { getStatusMap } from '../../utils/utils';

const EditDataMixin = mixin(editpage, [
    {
        excludes: [ 213, 207 ],
        methods: {
            customDataChanged(e) {
                const { gindex, index, column } = e.currentTarget.dataset;
                if (column.ID === 215) {
                    const statusMap = getStatusMap(column, { statusMap: this.getStatusMap(column) });
                    this.setColumn(column, e.detail.value ? statusMap[0] : statusMap[1]);
                    return true;
                }
            }
        },
        afterUpdate() {
            const item = this.getData().item;
            if (item.__c215 == 564) {
                setTimeout(() => {
                    this.redux.configSetting({ defaultAddress: item });
                }, 20);
            }
            wx.navigateBack();
        }
    }
]);

Page(getPage(EditDataMixin));
