import {list, loading, roundprocess, swiper} from '../../polaris/polaris';

import config from '../../config/config';
import editableListMixin from '../../module/editableListMixin';
import { fixImagePath } from '../../utils/utils';
import getPage from '../../module/page';
import mixin from '../../utils/mixin';
import regeneratorRuntime from '../../lib/regenerator-runtime/runtime';
import request from '../../config/request';
import viewpage from '../../module/viewpage';
import storage from '../../utils/storage';
import { createUpdate } from '../../utils/request';

const DashMixin = mixin(viewpage, [
  {
    data:{
       mobile:'',
       name:'',
       comment:'',
       vcode:'',
       pwd :'',
       contact:'',
       scode:false,
    },
    delayEnter: null,
    components: {
      roundprocess : {
        component: roundprocess,
        options() {
          return {
            autoRun: 3000,
            radius: 40,
            displayText: false,
            data: {
            }
          };
        }
      }
    },
    fetchOnEnter: false,
    loginLoading: false,
    loginFailed(error) {
      return true;
    },
    updateRedux({ login, user }) {

    },
    methods: {
      dataChange(e){
         let name = e.currentTarget.dataset.name;
         let nameMap = {};
         nameMap[name] = e.detail && e.detail.value;
         this.setData(nameMap);

      },
      moreButtonClicked(button, item) {



        if (button.id==="updateAccount"){

          let itx = this.getData();
          let rmobile = /^\d{11}$/;
          if (!itx.name  || !itx.mobile || !rmobile.test(itx.mobile)    ){
              wx.showModal({
                title: '提示',
                content: '姓名未填或手机号格式不对',
              });
             return false;
          }else{
            console.log(itx);
            //82784039-469f-40ec-b87b-e195d03b6df6   huozhu

              let RArray = [
                { _Key: '__c285', _Value: itx.name },
                { _Key: '__c288', _Value: itx.mobile },
                { _Key: '__c287', _Value: itx.contact },
              ];
           //   return false;

           console.log(RArray);
      //     return false;

             createUpdate({
                pageId:169,
                itemId:0,
                jsonStr:  RArray
             }).then(ret=>{

                  wx.showModal({
                  title: '提示',
                  content:  "感谢您的信任" ,
                  showCancel: false,//是否显示取消按钮
                  success: function (res) {

                        wx.switchTab({
                          url: '/pages/system/index'
                        });

                  }
                 });

             },
            ret =>{
                wx.showModal({                 title: '提示',                 content: "" ,               });
            }
           );



          }






        }




      },


    },
    onLoad() {
      this.getSystemInfo();
    },
    onReady() {


    }
  }
]);

Page(getPage(DashMixin, { pageId: 169 }));
