import { fixImagePath } from '../../utils/utils';
import getPage from '../../module/page';
import { list } from '../../polaris/polaris';
import listpage from '../../module/listpage';
import mixin from '../../utils/mixin';
import request from '../../config/request';

const BrandMixin = mixin(listpage, [{
  components: {
    list: {
      component: list,
      options() {
        return {
          customModifyItem(item) {
            item.section = {
              ID: 0,
              type: 'image-overlay',
              itemClass: 'm-b',
              fullMask: true,
              decorate: true
            };
            Object.assign(item, {
              url: fixImagePath(item.__c140.FilePath),
              primaryText: item.__c137,
              secondaryText: item.__c139?item.__c139.substr(0,30):''
            });
          }
        };
      }
    }
  },
  onLoad() {
    wx.getSystemInfo({
      success: function(res) {
        console.log('model', res.model)
        console.log('pixelRatio', res.pixelRatio)
        console.log('windowWidth', res.windowWidth)
        console.log('windowHeight', res.windowHeight)
        console.log('language', res.language)
        console.log('version', res.version)
        console.log('platform', res.platform)
      }
    });
  }
}]);

Page(getPage(BrandMixin, {
  pageId: 86
}));
