import { fixImagePath, formatDate, removeHtml } from '../../utils/utils';

import getPage from '../../module/page';
import { list } from '../../polaris/polaris';
import mixin from '../../utils/mixin';
import regeneratorRuntime from '../../lib/regenerator-runtime/runtime';
import request from '../../config/request';
import viewpage from '../../module/viewpage';

const ViewDataMixin = mixin(viewpage, [
    {
        components: {
            list
        },
        afterDetailFetched() {
            const item = this.detailData.data;
            item.__c246 = removeHtml(item.__c246);
            const section = [];
            section.push({
                ID: 0,
                type: 'swiper',
                items: [ { url: fixImagePath(item.__c247.FilePath) } ]
            });
            section.push({
                ID: 1,
                type: 'list-brand-header',
                class: 'padder-t-lg2 padder-b-sm bg-white',
                items: [
                    {
                        primaryText: item.__c243,
                        secondaryText: item.__c246,
                        decorate: true
                    }
                ]
            });
            const detail = [];
            detail.push(...(item.__c248 || []).map((i) => ({ url: fixImagePath(i.FilePath) })));
            section.push({
                ID: 3,
                type: 'image-full',
                header: {
                    type: 'header2',
                    title: '案例图文',
                    class: 'b-b bg-white',
                    decorate: true
                },
                class: 'm-t-sm padder-b bg-white',
                itemClass: 'padder padder-t',
                items: detail
            });
            this.coms.list.updateItems(section);
        }
    }
]);

Page(getPage(ViewDataMixin));
