import { fixImagePath, formatDate, removeHtml } from '../../utils/utils';

import getPage from '../../module/page';
import { list } from '../../polaris/polaris';
import listpage from '../../module/listpage';
import mixin from '../../utils/mixin';
import request from '../../config/request';

const ShowMixin = mixin(listpage, [
    {
        components: {
            list: {
                component: list,
                options() {
                    return {
                        customModifyItem(item) {
                            /*item.section = {
              ID: 0,
              type: 'list-image',
              imageLeft: true,
              class: 'b-t'
            };
            item.url = [fixImagePath(item.__c247)];
            item.primaryText = item.__c243;
            item.primaryClass= 'text-l-2 font-bold text-md2';
            item.secondaryText = removeHtml(item.__c246);
            item.secondaryClass = 'm-t-sm text-muted-d text-xs text-ellipsis';
            item.tertiaryText = formatDate(item.__c244, 'yyyy-MM-dd');
            item.tertiaryClass = 'm-t-half text-muted-d text-xs';
            item.imageWrap = 'padder-r w-35-b';
            item.imageClass = 'medium-height4';*/

                            item.section = {
                                ID: 0,
                                class: 'b-t',
                                tipClass: 'text-sm m-r-n'
                            };
                            Object.assign(item, {
                                parts: [
                                    {
                                        type: 'image-grid',
                                        avatar:
                                            'https://file3.bizsaas.com/files/2028/2017721/c263204f-d5de-45b6-a39c-cee4845b75f9.JPG',
                                        name: '街拍',
                                        des: formatDate(item.__c244, 'yyyy-MM-dd'),
                                        url: item.__c248.map((i) => fixImagePath(i.FilePath)),
                                        primaryText: item.__c243,
                                        __c242: item.__c242
                                    },
                                    {
                                        type: 'tips-bar',
                                        class: 'b-t m-b-sm',
                                        tips: [
                                            {
                                                icon: 'icon-eye',
                                                label: 22
                                            },
                                            {
                                                icon: 'icon-speech',
                                                label: 22
                                            },
                                            {
                                                icon: 'icon-star',
                                                label: 22
                                            }
                                        ]
                                    }
                                ]
                            });
                        }
                    };
                }
            }
        }
    }
]);

Page(
    getPage(ShowMixin, {
        pageId: 156
    })
);
