import { common } from '../../utils/request';
import { fixImagePath, formatDate, removeHtml, fixedEncodeURIComponent } from '../../utils/utils';
import { list, comment } from '../../polaris/polaris';

import { dateStr } from '../../utils/dateUtils';
import getPage from '../../module/page';
import mixin from '../../utils/mixin';
import viewpage from '../../module/viewpage';
import config from '../../config/config';
import request from '../../config/request';
import { upload,detail2 } from '../../utils/request';

const DashMixin = mixin(viewpage, [
    {
        components: {
            comment: {
                component: comment,
                options() {
                    return {
                        attachment: 'attachments',
                        sendComment: this.sendComment.bind(this)
                    };
                }
            }
        },
        tab: { tabType: 0, index: 0 },
        methods: {},
        onReady() {},
        onLoad() {
            wx.getSystemInfo({
                success: (res) => {
                    var windowHeight = res.windowHeight;
                    this.setData({
                        scrollHeight: windowHeight
                    });
                }
            });
        },
        getTabHeader() {
            return [
                {
                    title: '试题列表',
                    key: 'genjinjilu',
                    tabType: 0
                },
                {
                    title: '知识点剖析',
                    key: 'feedback',
                    tabType: 1
                }
                ,
                {
                    title: '设计稿',
                    key: 'info',
                    tabType: 2
                }
            ];
        },
        mainBody2() {
            const item = this.detailData.data;

            return {
                type: 'list-item-n',
                items: [
                    {
                        primaryText: item.__c2,
                        primaryClass: 'flex',
                        secondaryText: `编号 : ${item.__c41}`,
                        secondaryClass: `m-l-sm padder-v-xxs padder-xs r-3x bg-success text-white`,
                        // primaryText1: `开始时间:${formatDate(item.__c111)}`,
                        // secondaryText1: `结束时间:${formatDate(item.__c112)}`,
                        primaryText1: `时长 : ${item.__c42?item.__c42:''}`,

                        secondaryText1: `学员 : ${item.__c42?item.__c42:''}`,


                        secondaryText2: `开课时间 : ${item.__c51?formatDate(item.__c51, 'yyyy年MM月dd日 hh:mm'):''}`,
                      secondaryClass2: 'block break-all   text-minor text-sm'
                        // primaryText3: `教学能力评分:${item.__c107}`,
                        // secondaryText3: `教学态度评分:${item.__c108}`,
                        // primaryText4: `家长评价:${item.__c109}`
                    }
                ]
            };
        },
        mainBody3() {
            const item = this.detailData.data;
            return {
                ID: 3,
                type: 'view-text-pulldown',
                class: 'bg-white m-t-sm m-b-sm',
                bodyClass: 'w-full',
                contentClass: '',
                // header: {
                //     type: 'header2',
                //     itemClass: 'w-full justify-center',
                //     // icon2:'fa fa-arrow-circle-o-right text-base',
                //     title: `课堂内容`,
                //     titleClass: 'text-md',
                //     class: 'bg-white w-full padder-t padder'
                // },
                items: [
                    {
                        content: '课堂总结:\r\n' + removeHtml(item.__c48) + '\r\n\r\n教学目标:\r\n' + removeHtml(item.__c49)
                         + '\r\n\r\n重难点透视:\r\n' + removeHtml(item.__c48),
                        contentClass: 'text-base',
                        showImages: 1
                    }
                ]
            };
        },
        mainBody4() {
            return null;
        },
        tabInfo0() {
            const section = this.tabTopInfo();
            const item = this.detailData.data;

            section.push({
                ID: 1,
                type: 'list-column',
                key: 'tab',
                header: {
                    type: 'tablist',
                    selectedId: this.tab.index,
                    itemClass: 'bg-white',
                    class: 'b-b',
                    lineClass: 'line-50 b-b-2x b-blue',
                    list: this.getTabHeader()
                },
                items: item.related.length
                    ? item.related[0].list.map(( r ,z) => ({
                          ...r,
                          type: 'list-image',
                          class : 'padder-l padder-r padder-t',
                          primaryText:   '(' + (z+1).toString() + ')',
                          url: r.__c19?r.__c19.map((i) =>  i.FilePath):'',
                          imageWrap: 'w-full b-b padder-b',
                          imageClass: 'medium-width-280',
                          mode :'widthFix',
                      }))
                    : []
            });

            this.coms.list.updateItems(section);
        },
        tabInfo1(){

          const section = this.tabTopInfo();
          const item = this.detailData.data;

          section.push({
              ID: 1,
              type: 'list-column',
              key: 'tab',
              header: {
                  type: 'tablist',
                  selectedId: this.tab.index,
                  itemClass: 'bg-white',
                  class: 'b-b',
                  lineClass: 'line-50 b-b-2x b-blue',
                  list: this.getTabHeader()
              },
              items: item.related.length
                  ? item.related[1].list.map((r) => ({
                        ...r,
                        type: 'list-item-n',
                        primaryText: r.__c307,
                        primaryClass: 'flex',
                        // secondaryText: r.__c16 && r.__c16.statusName,
                        // secondaryClass: `m-l-sm padder-v-xxs padder-xs r-3x bg-gray l-h-2x text-white`,
                        primaryText1: `时间 : ${r.__c305}`,
                    //    secondaryText1: `掌握情况 : ${r.__c24?r.__c24:''}`,
                        primaryText2: '掌握情况 :' + removeHtml(r.__c306),
                        primaryClass2: `text-l-3 l-h-2x  text-minor`,

                    }))
                  : []
          });

          this.coms.list.updateItems(section);




        },
        tabInfo2() {
            const section = this.tabTopInfo();
            const item = this.detailData.data;



            section.push({
                ID: 1,
                type: 'list-column',
                key: 'tab',
                header: {
                    type: 'tablist',
                    selectedId: this.tab.index,
                    itemClass: 'bg-white',
                    class: 'b-b',
                    lineClass: 'line-50 b-b-2x b-blue',
                    list: this.getTabHeader()
                },
                items:  item.__c634.map((r) => ({
                          ...r,

                          id :'download',

                          type: 'list-item-n',
                          primaryText: r.Filename,
                          primaryClass: 'flex',
                          // secondaryText: r.__c16 && r.__c16.statusName,
                          // secondaryClass: `m-l-sm padder-v-xxs padder-xs r-3x bg-gray l-h-2x text-white`,


                      }))

            });

            this.coms.list.updateItems(section);





        },
        methods: {
            moreButtonClicked(button, item, gindex, index) {

                console.log(button);


                if (button.id==='download'){
                  wx.downloadFile({
                          url: 'https://file5.mvcx.net/jyrb/files/10036/202041/c759d66c-2dde-483c-bd79-bd3c119b9666.pdf',
                          success: function (res) {
                            console.log(res)
                            var Path = res.tempFilePath              //返回的文件临时地址，用于后面打开本地预览所用
                            wx.openDocument({
                              filePath: Path,
                              success: function (res) {
                                console.log('打开文档成功')
                              }
                            })
                          },
                          fail:function (res){
                            console.log(res)
                          }
                        })
                }




                if (button.id==='note'){

                  console.log( this.detailData.data);

                  this.itemNav({
                      pageId: 343,
                      params: {

                        itemId : this.detailData.data.__c51,
                        // ID :itemId
                      }
                  });

                return false;

                  this.fetchReq(
                      [
                          {
                              req: 'search2o',
                              params: {
                                  cid: 12,
                                  id: 239,
                                  lsc: [ { patternId: 103, val1:  this.detailData.data.server_identity, pTypeId: 23, operation: 1 } ],
                                  iindex: 0,
                                  isize: 1
                              }
                          }
                      ],
                      (data) => {

                          let sid ='';
                          let itemId =0;
                          if (data.data.length>0) {
                            sid = data.data[0].server_identity;
                            itemId = data.data[0].__c102 ;
                          }
                          console.log(itemId);

                          if (itemId==0){

                              this.itemNav({
                                  pageId: 89,
                                  params: {
                                    preItem : this.detailData.data,
                                  }
                              });

                          } else{

                              this.itemNav({
                                  pageId: 89,
                                  params: {
                                    preItem : this.detailData.data,
                                    server_identity: sid,
                                    itemId : itemId,
                                    // ID :itemId
                                  }
                              });

                          }

                      }
                  );
                }
                console.log(button);
            }
        },
        updateButtons() {
           console.log(this.redux.user);
           let btns =[
             //  {
             //     id: 'pinglun',
             //     icon: 'icon-pencil',
             //     iconClass: 'text-gray text-xlg',
             //     label: '评论'
             // }
           ];
           if (this.redux.user.RoleIds.toLowerCase().indexOf('e2202e30-0d20-471d-a27f-3f2f6e33e7b5')>=0){
               console.log('老师');
               btns.push(  {
                     id: 'note',
                     icon: 'icon-note',
                     iconClass: 'text-gray text-xlg',
                     label: '课堂反馈'
                 });
           }


            return  btns;
        },
        sendComment(comment, images) {
            const fileIds = [];
            const promises = [];
            for (let f in images) {
                const file = images[f];
                const promise = upload(0, file, this.redux.user.uploadKey).then((fileUpdata) => {
                    fileIds.push(fileUpdata.ID);
                });
                promises.push(promise);
            }
            Promise.all(promises).then(() => {
                const value = fileIds.join(',');
                request.comment(this, {
                    __c98: this.getData().item.server_identity,
                    __c97: value,
                    __c95: comment
                });
            });
        }
    }
]);

Page(getPage(DashMixin, {}));
