import getPage from '../../module/page';
import { list } from '../../polaris/polaris';
import listMoreButtons from '../../module/listMoreButtons';
import listpage from '../../module/listpage';
import mixin from '../../utils/mixin';
import request from '../../config/request';

const goodsBtns = [{
  id: 'collect',
  label: '收藏',
  icon: 'icon-star'
},
{
  id: 'buy',
  label: '购买',
  icon: 'icon-basket'
},
{
  id: 'import',
  label: '引入',
  icon: 'icon-action-redo'
}];

const CollectMixin = mixin(listpage, [{
  components: {
    list: {
      component: list,
      options() {
        return {
          moreButtons: goodsBtns
        };
      }
    }
  },
  selectMode: 'check',
  hasGrid: true,
  methods: {
    moreButtonClicked(button, data) {
      let items = (data ? [data] : this.coms.list.getSelectedItems()).map(item => Object.assign({ __c22: item.__c201 }, item));
      if (button.id === 'collect') {
        request.collectGoods(this, items);
      } else if (button.id === 'buy') {
        request.buyGoods(this, items);
      } else if (button.id === 'import') {
        request.importGoods(this, items);
      }
    }
  },
  extendModeButtons(button) {
    const buttons = listMoreButtons.extendModeButtons(this, button);
    buttons.push(...goodsBtns);
    return buttons;
  }
}]);

Page(getPage(CollectMixin, {
  pageId: 65
}));
