import { fixImagePath, formatDate, removeHtml } from '../../utils/utils';

import getPage from '../../module/page';
import { list } from '../../polaris/polaris';
import listpage from '../../module/listpage';
import mixin from '../../utils/mixin';
import request from '../../config/request';

const CommentMixin = mixin(listpage, [{
  components: {
    list: {
      component: list,
      options() {
        return {
          customModifyItem(item) {
            item.section = {
              ID: 0,
              type: 'list-comment',
              class: 'b-t'
            };
            Object.assign(item, {
              user: item.__c52.XingMing,
              time: formatDate(item.__c54, 'yyyy-MM-dd hh:mm:ss'),
              content: removeHtml(item.__c53),
              avatar: 'https://file3.bizsaas.com/files/2028/2017721/c263204f-d5de-45b6-a39c-cee4845b75f9.JPG',
              url: [fixImagePath(item.__c59[0])]
            });
          }
        }
      }
    }
  }
}]);

Page(getPage(CommentMixin, {
  pageId: 34
}));
