import getPage from '../../module/page';
import { list } from '../../polaris/polaris';
import listpage from '../../module/listpage';
import mixin from '../../utils/mixin';

const CustomerMixin = mixin(listpage, [{
  components: {
    list: {
      component: list,
      options() {
        return {
          methods: {
            handleMoreTap(e) {
              const item = this.getTapItem(e);
              this.emit('showFollow', this.page, {e, item}, [
                {
                  id: 'post',
                  label: '发送消息',
                  icon: 'icon-star'
                },
                {
                  id: 'add',
                  label: '添加好友',
                  icon: 'icon-user'
                },
              ]);
            }
          }
        };
      }
    }
  },
  methods: {
    moreButtonClicked(button, data) {
      if (button.id === 'post') {
        this.navigateTo('/pages/message/editmessage', {
          item: {
            __c120: { ID: data.__c225}
          }
        });
      } else if (button.id === 'add') {
        this.navigateTo('/pages/addfriend/index', {
          item: {
            __c120: { ID: data.__c225}
          }
        });
      }
    }
  },
  handleTapEvent(scope, index, item) {
    if (this.getChildEventScope(scope) === 'list') {
      if (this.coms.list.checkType !== '') {
        return;
      }

      const json = JSON.stringify({
        // lsc:{ patternId: 119, pTypeId: 12, operation: 1, val1: item.__c15.UserId }
      });
      const url = '/pages/message/index?json=' + json;
      wx.navigateTo({
        url
      });
    }
  }
}]);

Page(getPage(CustomerMixin, {
  pageId: 210
}));
