import {list, loading, swiper} from '../../polaris/polaris';

import {column} from '../../redux/column'
import config from '../../config/config';
import editableListMixin from '../../module/editableListMixin';
import { fixImagePath } from '../../utils/utils';
import getPage from '../../module/page';
import {login} from '../../redux/login';
import mixin from '../../utils/mixin';
import regeneratorRuntime from '../../lib/regenerator-runtime/runtime';
import request from '../../config/request';
import viewpage from '../../module/viewpage';

const DashMixin = mixin(viewpage, [
  editableListMixin, {
    fetchOnEnter: false,
    mustLogin: true,
    data: {
      placeholder: '请输入关键词',
      newMessage: true,
      newCart: true
    },
    components: {
      list
    },
    reduxState: [
      'login', 'user', 'params'
    ],
    reduxDispatch: {
      loginAction: login
    },
    cities: [],
    updateRedux(nextProps) {
      this.updateData({});
      const {login, user, params} = nextProps;
      if (this.redux.login !== login) {
        this.setData({login});
      }
      if (this.redux.user !== user) {
        this.setData({user});
      }

      if (this.redux.params !== params && params.type === 'dash') {

        if (params.data.jump) {
          this.itemNav({
            router: params.data.jump,
            params: params.data.params,
            tab: params.data.tab
          });
        }
      }
    },
    methods: {
      handleCityFocus() {
        this.emit('showPanelPicker', this.page,'cities', 'radio', true, [{ items: this.cities }]);
      },
      handleSearchInputFocus() {
       //  this.itemNav({router: '/pages/search/index'});
      },
      handleMessage() {
         return false;
        this.itemNav({
          pageId: 146
        });
      },
      handleCart() {
         return false;
        this.itemNav({pageId: 118});
      },
      handleSearchInputChanged(e) {
        this.setData({searchInput: ''});
        this.navigateTo('/pages/store/index', {searchInput: e.detail.value});
      }
    },
    onLoad() {
      this.on('panelPickerReturn', this.panelPickerReturn);
      wx.getSystemInfo({
        success: function(res) {
          console.log('model', res.model)
          console.log('pixelRatio', res.pixelRatio)
          console.log('windowWidth', res.windowWidth)
          console.log('windowHeight', res.windowHeight)
          console.log('language', res.language)
          console.log('version', res.version)
          console.log('platform', res.platform)
        }
      });
    },
    panelPickerReturn(scope, returnScope, key, selected) {
      if (returnScope === this.scope) {
        if (key === 'cities') {
          this.redux.configSetting({
            city: selected[0]
          });
        }
      }
    },
    updateData(data) {

      const s = '{"data":[[{"__c126":9,"__c127":{"att_identity":"D3AF93F7-3928-41DF-B1F3-3C2289EC44AB","FilePath":"https://file8.mvcx.net/files/2028/201794/100/c017c497-eba6-4310-a7e9-14c32ea46541.jpg"},"__c128":"","__c129":null,"__c130":{"ID":613,"statusName":"内容单列A"},"__c131":"走在时髦的尖端","__c132":"","__c133":"","__c134":{"UserId":"","XingMing":""},"__c135":null,"__c237":151,"ID":9,"server_identity":"852bffff-e29a-4496-bad6-53d89eb752b8","RowNum":1},{"__c126":8,"__c127":{"att_identity":"72292775-F409-4031-9C18-3A2E38171E87","FilePath":"https://file8.mvcx.net/files/2028/201794/100/de4ce608-4fe9-4fb1-b23a-f3359d26904c.jpg"},"__c128":"","__c129":null,"__c130":{"ID":674,"statusName":"内容双列A"},"__c131":"主题","__c132":"","__c133":"","__c134":{"UserId":"","XingMing":""},"__c135":null,"__c237":151,"ID":8,"server_identity":"2ace9165-6ecb-4f79-8f0a-6bdbe7a1b6e3","RowNum":2},{"__c126":7,"__c127":{"att_identity":"6FDDE9C7-9EDC-4ADA-BF75-95D585349111","FilePath":"https://file8.mvcx.net/files/2028/201794/100/66ea8280-8bcb-4937-8b5f-36e5f6e4d388.jpg"},"__c128":"","__c129":null,"__c130":{"ID":674,"statusName":"内容双列A"},"__c131":"最新活动","__c132":"","__c133":"","__c134":{"UserId":"","XingMing":""},"__c135":null,"__c237":151,"ID":7,"server_identity":"cf7877ff-8ef3-4298-a3b9-8c1420e0e81a","RowNum":3},{"__c126":6,"__c127":{"att_identity":"E26A93F9-843C-4768-AAF9-44D5DE0D634D","FilePath":"https://file8.mvcx.net/files/2028/201794/100/669542f2-c9a4-44dd-b41a-afb771351234.jpg"},"__c128":"","__c129":null,"__c130":{"ID":674,"statusName":"内容双列A"},"__c131":"名人堂","__c132":"","__c133":"","__c134":{"UserId":"","XingMing":""},"__c135":null,"__c237":151,"ID":6,"server_identity":"775d790b-6397-4beb-b567-15a7459472fc","RowNum":4},{"__c126":5,"__c127":{"att_identity":"28B7CBFF-E525-484C-8412-33D6C2074778","FilePath":"https://file8.mvcx.net/files/2028/201794/100/add814ea-7d85-4e91-abe1-a8319f325d52.jpg"},"__c128":"","__c129":null,"__c130":{"ID":674,"statusName":"内容双列A"},"__c131":"品牌故事","__c132":"","__c133":"","__c134":{"UserId":"","XingMing":""},"__c135":null,"__c237":151,"ID":5,"server_identity":"9ad67844-2fea-4be1-a576-660ee5b58a39","RowNum":5},{"__c126":4,"__c127":{"att_identity":"164BDECF-BC54-4FEE-B590-0B3CC136CC6D","FilePath":"https://file8.mvcx.net/files/2028/201794/100/0e09029d-9dc3-4fe5-869b-b5b143019219.jpg"},"__c128":"2017 最新款","__c129":null,"__c130":{"ID":686,"statusName":"通栏广告A"},"__c131":"FASHION TREND","__c132":"","__c133":"","__c134":{"UserId":"","XingMing":""},"__c135":null,"__c237":151,"ID":4,"server_identity":"837d6cd5-bd96-4510-901a-313d1bcba1c6","RowNum":6},{"__c126":3,"__c127":{"att_identity":"6C5BF90C-9D79-4A24-B32D-C217886D3F92","FilePath":"https://file8.mvcx.net/files/2028/201794/100/adf9d29c-0bfb-4e19-87f6-98853a0c9d0c.jpg"},"__c128":"首页中间banner1","__c129":80,"__c130":{"ID":612,"statusName":"顶部图片"},"__c131":"首页顶部导航3","__c132":"","__c133":"","__c134":{"UserId":"","XingMing":""},"__c135":"2017-07-27T00:00:00","__c237":151,"ID":3,"server_identity":"bb8fdb7f-107a-4272-b5bd-a4c66250ba12","RowNum":7},{"__c126":2,"__c127":{"att_identity":"68F6C035-9D01-464D-87D6-A106FA7B2FA5","FilePath":"https://file8.mvcx.net/files/2028/201794/100/2adf8e70-40f0-4b93-b68c-03e6a3d761eb.jpg"},"__c128":"","__c129":60,"__c130":{"ID":612,"statusName":"顶部图片"},"__c131":"首页顶部导航2","__c132":"","__c133":"","__c134":{"UserId":"","XingMing":""},"__c135":"2017-07-10T00:00:00","__c237":151,"ID":2,"server_identity":"25f36a6f-d875-406e-b88f-ae55372010b3","RowNum":8},{"__c126":1,"__c127":{"att_identity":"A977C2B2-8E4B-4762-81AA-C6C19356CA91","FilePath":"https://file8.mvcx.net/files/2028/201794/100/c5bedbe7-303e-47a3-8199-1705e4e807ac.jpg"},"__c128":"文字","__c129":100,"__c130":{"ID":612,"statusName":"顶部图片"},"__c131":"首页顶部导航1","__c132":"index11","__c133":"","__c134":{"UserId":"","XingMing":""},"__c135":"2017-07-02T00:00:00","__c237":151,"ID":1,"server_identity":"b3d75836-cc12-44c4-82c8-185098aab34d","RowNum":9}],[{"__c60":454,"__c61":"252844","__c62":"252844","__c63":"252844","__c64":4556,"__c65":{"att_identity":"ECA810AC-5106-4206-B424-22E24DD94D93","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/eca810ac-5106-4206-b424-22e24dd94d93.jpg"},"__c66":{"ID":2,"statusName":"已上架"},"__c67":null,"__c68":{"UserId":"43ae61bf-abcc-4eab-9f12-00addef4433b","XingMing":"客服管理A"},"__c69":"2017-09-29T02:24:00","__c70":[{"att_identity":"ECA810AC-5106-4206-B424-22E24DD94D93","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/eca810ac-5106-4206-b424-22e24dd94d93.jpg"},{"att_identity":"A568596F-0E65-400E-8024-9303EEB2D689","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/a568596f-0e65-400e-8024-9303eeb2d689.jpg"},{"att_identity":"E17095FF-5CE3-4BE0-9C9C-E406A54DB636","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/e17095ff-5ce3-4be0-9c9c-e406a54db636.jpg"},{"att_identity":"09E31849-AD67-4479-B532-A09018EBDFF2","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/09e31849-ad67-4479-b532-a09018ebdff2.jpg"},{"att_identity":"5EDF640C-BC0F-4375-8F92-AF4582E7FC57","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/5edf640c-bc0f-4375-8f92-af4582e7fc57.jpg"}],"__c71":true,"__c72":true,"__c73":true,"__c74":{"ID":636,"statusName":"鸡尾酒礼服"},"__c75":{"ID":691,"statusName":"发布会"},"__c76":[],"__c77":[],"__c78":[],"__c79":null,"__c312":[{"ID":703,"statusName":"L"},{"ID":701,"statusName":"S"}],"__c328":{"ID":707,"statusName":"💎💎"},"__c329":[],"__c330":[],"__c331":[],"__c332":[],"ID":454,"server_identity":"dd58f53b-fca5-456e-9893-48d41e3c0b2b","RowNum":1},{"__c60":449,"__c61":"252827","__c62":"252827","__c63":"252827","__c64":4531,"__c65":{"att_identity":"AF71E16C-3E3E-4EC4-A766-30E650C691FE","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/af71e16c-3e3e-4ec4-a766-30e650c691fe.jpg"},"__c66":{"ID":2,"statusName":"已上架"},"__c67":null,"__c68":{"UserId":"43ae61bf-abcc-4eab-9f12-00addef4433b","XingMing":"客服管理A"},"__c69":"2017-09-29T02:24:00","__c70":[{"att_identity":"AF71E16C-3E3E-4EC4-A766-30E650C691FE","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/af71e16c-3e3e-4ec4-a766-30e650c691fe.jpg"},{"att_identity":"FDA6E45B-6845-4A22-B095-C3E6BCF72A34","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/fda6e45b-6845-4a22-b095-c3e6bcf72a34.jpg"},{"att_identity":"6D22A0CB-9EAE-4AA5-A1EF-159334D17B57","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/6d22a0cb-9eae-4aa5-a1ef-159334d17b57.jpg"},{"att_identity":"9A0F893F-138F-4390-9838-83F42EC10059","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/9a0f893f-138f-4390-9838-83f42ec10059.jpg"},{"att_identity":"E41B5AFE-542F-4B36-A415-B3710581DE4A","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/e41b5afe-542f-4b36-a415-b3710581de4a.jpg"}],"__c71":true,"__c72":true,"__c73":true,"__c74":{"ID":636,"statusName":"鸡尾酒礼服"},"__c75":{"ID":625,"statusName":"party聚会"},"__c76":[],"__c77":[],"__c78":[],"__c79":null,"__c312":[{"ID":701,"statusName":"S"},{"ID":703,"statusName":"L"}],"__c328":{"ID":707,"statusName":"💎💎"},"__c329":[],"__c330":[],"__c331":[],"__c332":[],"ID":449,"server_identity":"4ed535f9-4304-4496-8c6d-6de8a9634d64","RowNum":2},{"__c60":441,"__c61":"252748","__c62":"252748","__c63":"252748","__c64":4491,"__c65":{"att_identity":"1EEB3591-8CB4-4F3D-BB6E-59F0478B3D4E","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/1eeb3591-8cb4-4f3d-bb6e-59f0478b3d4e.jpg"},"__c66":{"ID":2,"statusName":"已上架"},"__c67":null,"__c68":{"UserId":"43ae61bf-abcc-4eab-9f12-00addef4433b","XingMing":"客服管理A"},"__c69":"2017-09-29T02:24:00","__c70":[{"att_identity":"1EEB3591-8CB4-4F3D-BB6E-59F0478B3D4E","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/1eeb3591-8cb4-4f3d-bb6e-59f0478b3d4e.jpg"},{"att_identity":"B3E13018-F558-43C4-8B1B-D97FD7C9720F","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/b3e13018-f558-43c4-8b1b-d97fd7c9720f.jpg"},{"att_identity":"A5436308-AB73-4EAB-A58E-C480DF830E21","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/a5436308-ab73-4eab-a58e-c480df830e21.jpg"}],"__c71":true,"__c72":true,"__c73":true,"__c74":{"ID":636,"statusName":"鸡尾酒礼服"},"__c75":{"ID":624,"statusName":"公司酒会"},"__c76":[],"__c77":[],"__c78":[],"__c79":null,"__c312":[{"ID":703,"statusName":"L"},{"ID":700,"statusName":"XS"}],"__c328":{"ID":706,"statusName":"💎"},"__c329":[],"__c330":[],"__c331":[],"__c332":[],"ID":441,"server_identity":"8a41f1ba-d4b2-41f3-a990-00e8d457689f","RowNum":3},{"__c60":434,"__c61":"252708","__c62":"252708","__c63":"252708","__c64":4456,"__c65":{"att_identity":"504998BF-B0C7-4C3E-9447-1A5CEE48EE84","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/504998bf-b0c7-4c3e-9447-1a5cee48ee84.jpg"},"__c66":{"ID":2,"statusName":"已上架"},"__c67":null,"__c68":{"UserId":"43ae61bf-abcc-4eab-9f12-00addef4433b","XingMing":"客服管理A"},"__c69":"2017-09-29T02:24:00","__c70":[{"att_identity":"504998BF-B0C7-4C3E-9447-1A5CEE48EE84","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/504998bf-b0c7-4c3e-9447-1a5cee48ee84.jpg"},{"att_identity":"2E264ABE-9007-4206-A60F-A7673AF354B2","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/2e264abe-9007-4206-a60f-a7673af354b2.jpg"},{"att_identity":"D443CC55-4124-4AD6-AE51-24E38EB2EAB8","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/d443cc55-4124-4ad6-ae51-24e38eb2eab8.jpg"},{"att_identity":"CC967193-AAF5-4CE9-A8A7-E21C0B7F4241","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/cc967193-aaf5-4ce9-a8a7-e21c0b7f4241.jpg"},{"att_identity":"F46491A1-6DD3-4CF5-8902-82A9DFAE7E0A","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/f46491a1-6dd3-4cf5-8902-82a9dfae7e0a.jpg"}],"__c71":true,"__c72":true,"__c73":true,"__c74":{"ID":636,"statusName":"鸡尾酒礼服"},"__c75":{"ID":690,"statusName":"红毯走秀"},"__c76":[],"__c77":[],"__c78":[],"__c79":null,"__c312":[{"ID":700,"statusName":"XS"},{"ID":705,"statusName":"均码"},{"ID":701,"statusName":"S"}],"__c328":{"ID":706,"statusName":"💎"},"__c329":[],"__c330":[],"__c331":[],"__c332":[],"ID":434,"server_identity":"b173db66-ec9b-48f3-aa6b-3be212470007","RowNum":4},{"__c60":427,"__c61":"252672","__c62":"252672","__c63":"252672","__c64":4421,"__c65":{"att_identity":"204D4B56-4237-4C20-9038-5060B9126CC6","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/204d4b56-4237-4c20-9038-5060b9126cc6.jpg"},"__c66":{"ID":2,"statusName":"已上架"},"__c67":null,"__c68":{"UserId":"43ae61bf-abcc-4eab-9f12-00addef4433b","XingMing":"客服管理A"},"__c69":"2017-09-29T02:24:00","__c70":[{"att_identity":"204D4B56-4237-4C20-9038-5060B9126CC6","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/204d4b56-4237-4c20-9038-5060b9126cc6.jpg"},{"att_identity":"7336C387-4DC0-4793-965F-5B7607FF60F2","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/7336c387-4dc0-4793-965f-5b7607ff60f2.jpg"},{"att_identity":"1C5F0C80-21EE-4CE8-8291-2336ECAEC466","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/1c5f0c80-21ee-4ce8-8291-2336ecaec466.jpg"}],"__c71":true,"__c72":true,"__c73":true,"__c74":{"ID":636,"statusName":"鸡尾酒礼服"},"__c75":{"ID":691,"statusName":"发布会"},"__c76":[],"__c77":[],"__c78":[],"__c79":null,"__c312":[{"ID":702,"statusName":"M"},{"ID":705,"statusName":"均码"}],"__c328":{"ID":706,"statusName":"💎"},"__c329":[],"__c330":[],"__c331":[],"__c332":[],"ID":427,"server_identity":"e77881d8-8c9c-4c8f-9eca-1a41873fce4c","RowNum":5},{"__c60":417,"__c61":"252613","__c62":"252613","__c63":"252613","__c64":4371,"__c65":{"att_identity":"1224B31E-EE58-47A6-85E2-9610CC765CF7","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/1224b31e-ee58-47a6-85e2-9610cc765cf7.jpg"},"__c66":{"ID":2,"statusName":"已上架"},"__c67":null,"__c68":{"UserId":"43ae61bf-abcc-4eab-9f12-00addef4433b","XingMing":"客服管理A"},"__c69":"2017-09-29T02:24:00","__c70":[{"att_identity":"1224B31E-EE58-47A6-85E2-9610CC765CF7","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/1224b31e-ee58-47a6-85e2-9610cc765cf7.jpg"},{"att_identity":"F09AA8F6-AC54-4F43-988F-0F9D9C715D77","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/f09aa8f6-ac54-4f43-988f-0f9d9c715d77.jpg"},{"att_identity":"088E7D94-11F9-43A9-855E-67125DF2A89F","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/088e7d94-11f9-43a9-855e-67125df2a89f.jpg"},{"att_identity":"0C6B2CD1-4814-4B2E-89FD-A702E0E42545","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/0c6b2cd1-4814-4b2e-89fd-a702e0e42545.jpg"},{"att_identity":"0722EF30-887D-468A-8BF4-0AD36B6A843B","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/0722ef30-887d-468a-8bf4-0ad36b6a843b.jpg"}],"__c71":true,"__c72":true,"__c73":true,"__c74":{"ID":636,"statusName":"鸡尾酒礼服"},"__c75":{"ID":628,"statusName":"成人礼"},"__c76":[],"__c77":[],"__c78":[],"__c79":null,"__c312":[{"ID":704,"statusName":"XL"},{"ID":701,"statusName":"S"},{"ID":700,"statusName":"XS"}],"__c328":{"ID":707,"statusName":"💎💎"},"__c329":[],"__c330":[],"__c331":[],"__c332":[],"ID":417,"server_identity":"33a2d11b-59fb-4bc5-b849-730e1882cd16","RowNum":6},{"__c60":416,"__c61":"252612","__c62":"252612","__c63":"252612","__c64":4366,"__c65":{"att_identity":"C71EEB64-5200-449C-B51A-2787BD74D743","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/c71eeb64-5200-449c-b51a-2787bd74d743.jpg"},"__c66":{"ID":2,"statusName":"已上架"},"__c67":null,"__c68":{"UserId":"43ae61bf-abcc-4eab-9f12-00addef4433b","XingMing":"客服管理A"},"__c69":"2017-09-29T02:24:00","__c70":[{"att_identity":"C71EEB64-5200-449C-B51A-2787BD74D743","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/c71eeb64-5200-449c-b51a-2787bd74d743.jpg"},{"att_identity":"59FAB730-4540-419E-AC76-7E368ACB05F5","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/59fab730-4540-419e-ac76-7e368acb05f5.jpg"},{"att_identity":"099D4A08-32E9-4745-A766-27B036B8F35F","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/099d4a08-32e9-4745-a766-27b036b8f35f.jpg"},{"att_identity":"C061B0D7-F677-4BEA-AAB7-78B0D1085661","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/c061b0d7-f677-4bea-aab7-78b0d1085661.jpg"},{"att_identity":"8D0C1B9B-A970-4ED6-95A4-93E0E2CD52D3","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/8d0c1b9b-a970-4ed6-95a4-93e0e2cd52d3.jpg"}],"__c71":true,"__c72":true,"__c73":true,"__c74":{"ID":636,"statusName":"鸡尾酒礼服"},"__c75":{"ID":623,"statusName":"婚礼"},"__c76":[],"__c77":[],"__c78":[],"__c79":null,"__c312":[{"ID":704,"statusName":"XL"},{"ID":703,"statusName":"L"}],"__c328":{"ID":706,"statusName":"💎"},"__c329":[],"__c330":[],"__c331":[],"__c332":[],"ID":416,"server_identity":"9d1899b0-94f2-48cc-b23f-2ad6881ffa9a","RowNum":7},{"__c60":413,"__c61":"252579","__c62":"252579","__c63":"252579","__c64":4351,"__c65":{"att_identity":"D04D0C74-8BD9-44B3-B2A4-AE888712CEA8","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/d04d0c74-8bd9-44b3-b2a4-ae888712cea8.jpg"},"__c66":{"ID":2,"statusName":"已上架"},"__c67":null,"__c68":{"UserId":"43ae61bf-abcc-4eab-9f12-00addef4433b","XingMing":"客服管理A"},"__c69":"2017-09-29T02:24:00","__c70":[{"att_identity":"D04D0C74-8BD9-44B3-B2A4-AE888712CEA8","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/d04d0c74-8bd9-44b3-b2a4-ae888712cea8.jpg"},{"att_identity":"F1242605-CCC1-4247-A747-4C2F50E87165","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/f1242605-ccc1-4247-a747-4c2f50e87165.jpg"},{"att_identity":"755ECB00-D43E-452D-A187-685AA05FDA35","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/755ecb00-d43e-452d-a187-685aa05fda35.jpg"},{"att_identity":"50DD5ACD-A7C1-4E66-89F3-2928AABEFFAC","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/50dd5acd-a7c1-4e66-89f3-2928aabeffac.jpg"}],"__c71":true,"__c72":true,"__c73":true,"__c74":{"ID":636,"statusName":"鸡尾酒礼服"},"__c75":{"ID":629,"statusName":"写真摄影"},"__c76":[],"__c77":[],"__c78":[],"__c79":null,"__c312":[{"ID":700,"statusName":"XS"},{"ID":703,"statusName":"L"}],"__c328":{"ID":707,"statusName":"💎💎"},"__c329":[],"__c330":[],"__c331":[],"__c332":[],"ID":413,"server_identity":"4766dc63-c57b-4d95-b351-10b59b1bcd84","RowNum":8},{"__c60":401,"__c61":"252448","__c62":"252448","__c63":"252448","__c64":4291,"__c65":{"att_identity":"31F3D8B8-056B-4619-B174-D8DF6AE4CA6F","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/31f3d8b8-056b-4619-b174-d8df6ae4ca6f.jpg"},"__c66":{"ID":2,"statusName":"已上架"},"__c67":null,"__c68":{"UserId":"43ae61bf-abcc-4eab-9f12-00addef4433b","XingMing":"客服管理A"},"__c69":"2017-09-29T02:24:00","__c70":[{"att_identity":"31F3D8B8-056B-4619-B174-D8DF6AE4CA6F","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/31f3d8b8-056b-4619-b174-d8df6ae4ca6f.jpg"},{"att_identity":"FFEF6AD3-CA1B-4075-9495-9B181D0BDF5C","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/ffef6ad3-ca1b-4075-9495-9b181d0bdf5c.jpg"},{"att_identity":"22DE3E1E-47D7-465A-8C7D-65BCD36E279F","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/22de3e1e-47d7-465a-8c7d-65bcd36e279f.jpg"}],"__c71":true,"__c72":true,"__c73":true,"__c74":{"ID":636,"statusName":"鸡尾酒礼服"},"__c75":{"ID":629,"statusName":"写真摄影"},"__c76":[],"__c77":[],"__c78":[],"__c79":null,"__c312":[{"ID":704,"statusName":"XL"},{"ID":702,"statusName":"M"}],"__c328":{"ID":707,"statusName":"💎💎"},"__c329":[],"__c330":[],"__c331":[],"__c332":[],"ID":401,"server_identity":"fabe796c-8de9-44d5-b013-10911353b81b","RowNum":9},{"__c60":399,"__c61":"252435","__c62":"252435","__c63":"252435","__c64":4281,"__c65":{"att_identity":"03ADB7C9-A607-4FBB-BCF9-0E832E718A67","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/03adb7c9-a607-4fbb-bcf9-0e832e718a67.jpg"},"__c66":{"ID":2,"statusName":"已上架"},"__c67":null,"__c68":{"UserId":"43ae61bf-abcc-4eab-9f12-00addef4433b","XingMing":"客服管理A"},"__c69":"2017-09-29T02:24:00","__c70":[{"att_identity":"03ADB7C9-A607-4FBB-BCF9-0E832E718A67","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/03adb7c9-a607-4fbb-bcf9-0e832e718a67.jpg"},{"att_identity":"5C763627-2A5A-42DE-9BDD-7285A756F642","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/5c763627-2a5a-42de-9bdd-7285a756f642.jpg"},{"att_identity":"CA58D692-FAE4-4C10-8EB9-FCC5E3EE5890","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/ca58d692-fae4-4c10-8eb9-fcc5e3ee5890.jpg"},{"att_identity":"5B7AF70C-9FEF-49F0-B06F-0381027C3F8B","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/5b7af70c-9fef-49f0-b06f-0381027c3f8b.jpg"},{"att_identity":"979DA39A-24A6-43E3-804A-DD6851C39F8D","FilePath":"https://file8.mvcx.net/files/2028/2017929/100/979da39a-24a6-43e3-804a-dd6851c39f8d.jpg"}],"__c71":true,"__c72":true,"__c73":true,"__c74":{"ID":636,"statusName":"鸡尾酒礼服"},"__c75":{"ID":628,"statusName":"成人礼"},"__c76":[],"__c77":[],"__c78":[],"__c79":null,"__c312":[{"ID":702,"statusName":"M"},{"ID":700,"statusName":"XS"},{"ID":704,"statusName":"XL"}],"__c328":{"ID":706,"statusName":"💎"},"__c329":[],"__c330":[],"__c331":[],"__c332":[],"ID":399,"server_identity":"94a66f81-ef1c-4d7b-8503-d4f937f1d73a","RowNum":10}],[{"__c142":6,"__c143":{"UserId":"43ae61bf-abcc-4eab-9f12-00addef4433b","XingMing":"客服管理A"},"__c144":{"ID":37,"statusName":"上海"},"__c145":{"ID":150,"statusName":"上海"},"__c146":"2000000","__c147":"","__c148":"4006821413","__c149":"上海QWedding·芊寻海外婚礼","__c150":"","__c151":false,"__c152":[{"att_identity":"11DA3EFB-367B-4F48-9CA4-290ED6C42638","FilePath":"https://file8.mvcx.net/files/2028/201794/100/2bfaaf56-9819-451c-9c8f-1bbc025cccaa.jpg"}],"__c153":"上海QWedding·芊寻海外婚礼","__c154":null,"__c155":null,"__c156":null,"__c157":null,"__c158":null,"__c159":null,"__c160":"4006821413","__c253":{"att_identity":"F1E4188F-70B4-4995-B6FC-EE1FAE01C678","FilePath":"https://file8.mvcx.net/files/2028/201794/100/ee624e8e-9680-46eb-82f9-75cc305f8318.jpg"},"__c304":"上海静安区西藏北路605号兴中心3g产业园b座201","ID":6,"server_identity":"5412944e-8e7e-4a39-ab3d-629e22df81ac","RowNum":1},{"__c142":5,"__c143":{"UserId":"2ac0c000-985f-4d13-a504-f5061bba4bc6","XingMing":"8c18c26a"},"__c144":{"ID":37,"statusName":"上海"},"__c145":{"ID":150,"statusName":"上海"},"__c146":"2000000","__c147":"","__c148":"400-820-6521","__c149":"叶氏婚纱摄影","__c150":"","__c151":false,"__c152":[{"att_identity":"54FD81E0-60CB-4247-B5EE-900B46D10D2D","FilePath":"https://file8.mvcx.net/files/2028/201794/100/530a8bda-be39-4a94-bed0-3e541026e54d.jpg"}],"__c153":"叶氏婚纱摄影","__c154":null,"__c155":null,"__c156":null,"__c157":null,"__c158":null,"__c159":null,"__c160":"400-820-6521","__c253":{"att_identity":"F4ED1F4E-97E3-4EEF-9749-DDAC12688102","FilePath":"https://file8.mvcx.net/files/2028/201794/100/fd1fef5b-377b-479c-afbe-ef83bff82911.jpg"},"__c304":"上海市宝山区牡丹江路1660号","ID":5,"server_identity":"519c0825-d722-4e5d-9b85-e5abc7308c99","RowNum":2},{"__c142":4,"__c143":{"UserId":"2ac0c000-985f-4d13-a504-f5061bba4bc6","XingMing":"8c18c26a"},"__c144":{"ID":37,"statusName":"上海"},"__c145":{"ID":150,"statusName":"上海"},"__c146":"200000","__c147":"","__c148":"18818080972","__c149":"上海米雪儿婚纱摄影","__c150":"","__c151":false,"__c152":[{"att_identity":"05BCB795-760D-4418-A5C6-C8105E234F7D","FilePath":"https://file8.mvcx.net/files/2028/201794/100/f9ab9cec-50a3-4563-9148-cdc2417e5d77.jpg"}],"__c153":"上海米雪儿婚纱摄影","__c154":null,"__c155":null,"__c156":null,"__c157":null,"__c158":null,"__c159":null,"__c160":"18818080972","__c253":{"att_identity":"18D02DF0-FA91-46B4-B14A-F5A7ED04EFB3","FilePath":"https://file8.mvcx.net/files/2028/201794/100/7d6bb45b-fece-4fed-bce4-234f9e40e8ec.jpg"},"__c304":"都市路2501弄307号202","ID":4,"server_identity":"86d8e1a0-0b4b-4900-8962-1c60af4e67a5","RowNum":3},{"__c142":3,"__c143":{"UserId":"2ac0c000-985f-4d13-a504-f5061bba4bc6","XingMing":"8c18c26a"},"__c144":{"ID":37,"statusName":"上海"},"__c145":{"ID":150,"statusName":"上海"},"__c146":"200000","__c147":"","__c148":"021-56961213","__c149":"上海女王驾到婚纱摄影","__c150":"","__c151":false,"__c152":[{"att_identity":"2EB3B2D6-C4B8-46AB-83F6-932F551BF537","FilePath":"https://file8.mvcx.net/files/2028/201794/100/f9358545-074c-4fdf-bbd1-46a0806d60a1.jpg"}],"__c153":"上海女王驾到婚纱摄影","__c154":null,"__c155":null,"__c156":null,"__c157":null,"__c158":null,"__c159":null,"__c160":"021-56961213","__c253":{"att_identity":"1F51AC06-0C22-4E67-9146-DCE9E491ABD8","FilePath":"https://file8.mvcx.net/files/2028/201794/100/320deb22-e6cf-407e-bd55-5b489dd205ce.jpg"},"__c304":"上海市虹口区花园路84号2号楼（凯德龙之梦对面）","ID":3,"server_identity":"6aa905b0-93c4-41e6-a787-7d7fdbbb6076","RowNum":4},{"__c142":2,"__c143":{"UserId":"2ac0c000-985f-4d13-a504-f5061bba4bc6","XingMing":"8c18c26a"},"__c144":{"ID":38,"statusName":"江苏"},"__c145":{"ID":151,"statusName":"南京"},"__c146":"210000","__c147":"","__c148":"025-57905868","__c149":"南京唯一视觉婚纱摄影","__c150":"","__c151":false,"__c152":[{"att_identity":"9CA731B0-A2B7-4DE2-A9AA-53CF0DB6004D","FilePath":"https://file8.mvcx.net/files/2028/201794/100/f5ed419b-b357-44ab-9acf-38284d406357.jpg"}],"__c153":"南京唯一视觉婚纱摄影","__c154":null,"__c155":null,"__c156":null,"__c157":null,"__c158":null,"__c159":null,"__c160":"025-57905868","__c253":{"att_identity":"98479504-DBD1-45B8-9AAC-3CD5FA931C13","FilePath":"https://file8.mvcx.net/files/2028/201794/100/597519e7-193a-4643-9d9a-fec7cfdacc8d.jpg"},"__c304":"洪武路38号（新街口）正洪大厦17楼1707、1708室","ID":2,"server_identity":"04cbf533-58aa-4726-9634-967df4801cfa","RowNum":5},{"__c142":1,"__c143":{"UserId":"6886cf14-7922-409e-be59-9192577899a1","XingMing":"PromDress"},"__c144":{"ID":38,"statusName":"江苏"},"__c145":{"ID":151,"statusName":"南京"},"__c146":"21000","__c147":"","__c148":"138512212","__c149":"南京米兰尊荣婚纱摄影会馆","__c150":"","__c151":false,"__c152":[{"att_identity":"28AB142D-55F8-4E84-9782-4DF51AE556E9","FilePath":"https://file8.mvcx.net/files/2028/201794/100/128aed06-94e7-4712-9268-a0a0b74a47c8.jpg"}],"__c153":"南京米兰尊荣婚纱摄影会馆","__c154":1,"__c155":3,"__c156":3,"__c157":3,"__c158":null,"__c159":null,"__c160":"025-83112228","__c253":{"att_identity":"2896BD64-9EE5-4F7C-8D1F-2DF86E7B6DF6","FilePath":"https://file8.mvcx.net/files/2028/201794/100/c73886a0-5c1e-4c80-9b88-63040c56cf85.jpg"},"__c304":"中央路258-27号新立基大厦 地铁1号线新模范马路站4号出口","ID":1,"server_identity":"90953495-b216-4b5c-bfad-386bb5ca7216","RowNum":6}],[{"__c230":null,"ID":null,"server_identity":null,"message":2}],[{"__c197":null,"ID":null,"server_identity":null,"cart":96}]],"returnCode":null,"message":"from cache","returnType":0,"d":null}';

      data = JSON.parse(s);

      const sections = [];

      this.setData({
        newMessage: data.data[3][0].message,
        newCart: data.data[4][0].cart
      });

      const header = data
        .data[0]
        .map(f => Object.assign({
          url: fixImagePath(f.__c127.FilePath),
          router: f.__c132
        }, f));

      const header2 = header.filter((item) => item.__c130.ID === 612);

      sections.push({ ID: 's1', type: 'swiper', items: header2 });

      this.cities = data.data[2].map(item => Object.assign({ primaryText: item.__c145.statusName }, item.__c145));

      //revision 100;

      const guideData = [
        {
          url: '/images/chanpin.png',
          label: '霓裳',
      //    pageId: 41,
          tab:true,
        }, {
          url: '/images/yuyue.png',
          label: '品牌',
    //      pageId: 86
        }, {
          url: '/images/shoucang.png',
          label: '名人堂',
    //      pageId: 3
        }, {
          url: '/images/jingxiaoshang.png',
          label: '门店',
  //        pageId: 94
        }, {
          url: '/images/dingdan.png',
          label: '案例',
    //      pageId: 156
        }, {
          url: '/images/huodong.png',
          label: '活动',
  //        pageId: 152
        }, {
          url: '/images/zhuti.png',
          label: '主题',
  //        pageId: 153,
          tab:true,
        }, {
          url: '/images/yingyong.png',
          label: '应用',
  //        pageId: 80000
        }
      ];

      sections.push({
        ID: 's2',
        type: 'grid',
        class: 'wrapper bg-white',
        itemClass: 'col-xs-3 wrapper-sm',
        items: guideData.map((item, index) => Object.assign(item, {
          ID: index,
          icon: item.icon,
          labelClass: 'text-xs m-t',
          label: item.label
        }))
      });

      const banner = header.filter((item) => item.__c130.ID === 686);

      sections.push({
        ID: 's3',
        type: 'swiper',
        sizeClass: 'height-large-ultra-wide',
        fullMask: true,
        items: banner
      });

      const double = header.filter((item) => item.__c130.ID === 674).map(i => Object.assign({ primaryText: i.__c131 }, i));

      sections.push({
        ID: 's4',
        decorate: true,
        type: 'grid-overlay',
        class: 'padder-half padder-v bg-white',
        itemClass: 'col-xs-6',
        items: double
      });

      const banner2 = header.filter((item) => item.__c130.ID === 613).map(item => Object.assign({ primaryClass: 'text-lg' }, item));

      sections.push({
        ID: 's5',
        type: 'swiper',
        decorate: true,
        sizeClass: 'height-large-wide',
        fullMask: true,
        textClass: 'bg-black-opacity-lt',
        items: banner2
      });

      const goods = data
        .data[1]
        .map(f => Object.assign({
          url: f.__c65.FilePath,
          primaryText: f.__c61,
          price: f.__c64,
          pageId: 46,
          ID: f.ID
        }, f));

      sections.push({
        ID: 's6',
        type: 'grid-card',
        items: goods,
      //  pageId: 46,
        class: 'padder-half padder-t-lg2 bg-white',
        header: {
          type: 'header4',
          title: '新款推荐',
          subTitle: '更多产品',
          class: 'padder-half padder-b',
          button: {
        //    pageId: 41
          }
        }
      });

      this
        .coms
        .list
        .updateItems(sections);
    }
  }
]);

Page(getPage(DashMixin, { pageId: 172 }));
