import { fixImagePath, formatDate, removeHtml } from '../../utils/utils';

import getPage from '../../module/page';
import { list } from '../../polaris/polaris';
import mixin from '../../utils/mixin';
import regeneratorRuntime from '../../lib/regenerator-runtime/runtime';
import request from '../../config/request';
import viewpage from '../../module/viewpage';

const ViewDataMixin = mixin(viewpage, [
    {
        components: {
            list
        },
        updateButtons() {
            return [
                {
                    id: 'like',
                    label: '膜拜',
                    icon: 'fa fa-thumbs-o-up'
                },
                {
                    id: 'dislike',
                    label: '无视',
                    icon: 'fa fa-thumbs-o-down'
                }
            ];
        },
        methods: {
            moreButtonClicked(button) {
                const item = this.getData().item;
                if (button.id === 'like') {
                    request.like(this, {
                        __c48: item.server_identity
                    });
                } else if (button.id === 'dislike') {
                    request.dislike(this, {
                        __c48: item.server_identity
                    });
                } else if (button.id === 'attention') {
                    request.attention(
                        this,
                        {
                            __c309: this.redux.user.UserId,
                            __c311: item.server_identity
                        },
                        () => {
                            const idColumn = this.getOption('idColumn');
                            this.emit('refresh_data', null, idColumn, [
                                {
                                    __c309: this.redux.user,
                                    [idColumn]: item[idColumn]
                                }
                            ]);
                        }
                    );
                }
            }
        },
        afterDetailFetched() {
            const item = this.detailData.data;
            item.__c5 = removeHtml(item.__c5);

            const section = [];

            section.push({
                ID: 0,
                type: 'swiper',
                items: [ { url: fixImagePath(item.__c3.FilePath) } ]
            });

            section.push({
                ID: 1,
                type: 'list-dealer-header',
                class: 'padder-t-xs bg-white',
                itemClass: 'padder-b-md b-b',
                items: [
                    {
                        server_identity: item.server_identity,
                        primaryText: item.__c2.XingMing,
                        secondaryText: item.__c307,
                        attention: item.__c309 && item.__c309.UserId
                        // tertiaryText: '婚礼策划',
                        // quartusText: '关注 690'
                    }
                ]
            });

            section.push({
                ID: 2,
                type: 'list-item',
                class: 'padder-t',
                items: [
                    {
                        icon: 'icon-clock',
                        primaryText: `入选时间: ${formatDate(item.__c6, 'yyyy年MM月dd日')}`,
                        noNav: true
                    },
                    {
                        icon: 'icon-location-pin',
                        primaryText: `我的城市: ${item.__c7.statusName}`,
                        noNav: true
                    },
                    {
                        icon: ' icon-trophy',
                        primaryText: `礼赞: ${item.__c5}`,
                        noNav: true
                    }
                ]
            });

            const detail = [
                {
                    content: item.__c8
                }
            ];
            detail.push(...item.__c4.map((i) => ({ url: fixImagePath(i.FilePath) })));
            section.push({
                ID: 3,
                type: 'image-full',
                header: {
                    type: 'header2',
                    title: '我的宣言',
                    class: 'b-b bg-white',
                    decorate: true
                },
                class: 'm-t-sm padder-b bg-white',
                itemClass: 'padder padder-t',
                items: detail
            });

            this.coms.list.updateItems(section);
        }
    }
]);

Page(getPage(ViewDataMixin));
