import config from '../../config/config';
import getPage from '../../module/page';
import { list } from '../../polaris/polaris';
import listpage from '../../module/listpage';
import mixin from '../../utils/mixin';

const FunctionMixin = mixin(listpage, [{
  onLoad() {
    const sections = [];
    sections.push(
      {
        type: 'grid',
        class: 'm-b-sm padder-b bg-white',
        itemClass: 'col-xs-4 padder-t',
        header: {
          decorate: true,
          type: 'header2',
          class: 'b-t b-b',
          title: '必备',
        },
        items: [
          {
            url: '/images/yuyuef.png',
            label: '预约',
            pageId: 72
          },
          {
            url: '/images/dingdanf.png',
            label: '订单',
            pageId: 102
          },
          {
            url: '/images/dingyuef.png',
            label: '购物车',
            pageId: 118
          }
        ].map((item, index) => Object.assign(item))
      });
    sections.push(
      {
        type: 'grid',
        class: 'm-b-sm padder-b bg-white',
        header: {
          decorate: true,
          type: 'header2',
          class: 'b-t b-b',
          title: '工具',
        },
        itemClass: 'col-xs-4 padder-t',
        items: [
          {
            url: '/images/shoucangf.png',
            label: '收藏',
            pageId: 125
          },
          {
            url: '/images/huodongf.png',
            label: '活动',
            pageId: 11
          },
          {
            url: '/images/zhaopinf.png',
            label: '招聘'
          }
        ].map((item, index) => Object.assign(item))
      });
    sections.push(
      {
        type: 'grid',
        itemClass: 'col-xs-4 padder-t',
        class: 'm-b-sm padder-b bg-white',
        header: {
          decorate: true,
          type: 'header2',
          class: 'b-t b-b',
          title: '应用',
        },
        items: [
          {
            url: '/images/jingxiaoshangf.png',
            label: '门店',
            pageId: 94
          },
          {
            url: '/images/zhutif.png',
            label: '主题',
            pageId: 47
          },
          {
            url: '/images/dingyuef.png',
            label: '订阅',
          },
          {
            url: '/images/shoucangf.png',
            label: '生活'
          },
          {
            url: '/images/huodongf.png',
            label: '风尚',
            // pageId: 144
          },
          {
            url: '/images/yingyong.png',
            label: '好东西',
            pageId: 41
          }
        ].map((item, index) => Object.assign(item))
      }
    );
    this.coms.list.updateItems(sections);
  },
}]);

Page(getPage(FunctionMixin, {
}));
