import { list, loading, roundprocess, swiper } from '../../polaris/polaris';

import config from '../../config/config';
import editableListMixin from '../../module/editableListMixin';
import { fixImagePath } from '../../utils/utils';
import getPage from '../../module/page';
import mixin from '../../utils/mixin';
import regeneratorRuntime from '../../lib/regenerator-runtime/runtime';
import request from '../../config/request';
import viewpage from '../../module/viewpage';

const DashMixin = mixin(viewpage, [
    {
        mustLogin:false,
        delayEnter: null,
        components: {
            roundprocess: {
                component: roundprocess,
                options() {
                    return {
                        data: {
                            visible: false
                        }
                    };
                }
            }
        },
        // fetchOnEnter: false,
        // updateRedux({ login }) {
        //   if (this.redux.login !== login) {
        //     if (!login.fetching && !login.error && login.wxLogined) {
        //       this.fetchDetail();
        //     }

        //     this.setData({ login });
        //   }
        // },
        methods: {
            enterNow() {



                    this.delayEnter && clearInterval(this.delayEnter);
                    wx.switchTab({ url: '/pages/dash/index' });


            }
        },
        fetchDetail() {
            request.fetchMain(this, (data) => {
                this.setData({
                    fetched: true
                });
                this.redux.updateParams({
                    type: 'dash',
                    data: {
                        data,
                        jump: this.options.jump,
                        params: this.options.params,
                        tab: this.options.tab
                    }
                });
                this.delay = 3000;
                this.delayEnter = setInterval(() => {
                    this.delay -= 200;
                    this.coms.roundprocess.process = this.delay / 3000;
                    this.coms.roundprocess.setData({
                        text: Math.ceil(this.delay / 1000)
                    });
                    this.coms.roundprocess.updateProcess();
                    if (this.delay <= 0) {
                        this.enterNow();
                    }
                }, 200);
                this.coms.roundprocess.setVisible();
            });
        },
        onLoad() {
            wx.getSystemInfo({
                success: (res) => {
                    var windowHeight = res.windowHeight;
                    this.setData({
                        windowHeight
                    });
                }
            });
        },
        onReady() {



            // this.handleLogin();
        }
    }
]);

Page(getPage(DashMixin, { pageId: 172 }));
