import { formatDate, removeHtml } from '../../utils/utils';

import getPage from '../../module/page';
import { filtab, list } from '../../polaris/polaris';
import listpage from '../../module/listpage';
import mixin from '../../utils/mixin';
import request from '../../config/request';
import fetchListMixin from '../../module/fetchListMixin';

const ListDataMixin = mixin(listpage, [{
  components: {
    filtab: {
                  component: filtab,
                  options() {
                      return {
                          refreshColumns: true
                      };
                  }
    },
    list: {
      component: list,
      options() {



        return {
          customModifyItem(item) {


             const currentFilter = this.redux.filter[this.getOption('pageId')] ;
             const subPage =  currentFilter.pageConfig.subPages.find(x=>x.pageType==14);
             const subPageKey = subPage?('eorder_'+subPage.ID.toString()):'eorder';



             const currentColumns = currentFilter.pageConfig.columns.columns.sort((a,b)=>
                      a[subPageKey] -b[subPageKey]
              );

              //   (a[subPageKey]?a[subPageKey]:1000) -  (b[subPageKey]?b[subPageKey]:1000)





             let key = {};
             const includePTypeIds =[2,3,4,5,6,7,12,13];
             const keys = currentColumns.filter(column => includePTypeIds.indexOf(column.pTypeId)>=0   );
             for(let ii = 0 ; ii < keys.length && ii < 10; ii ++) {
                  let v = item[keys[ii].eid];
                 switch (keys[ii].pTypeId) {
                   case 6:
                      v = formatDate(v, 'yyyy-MM-dd');
                     break;
                   case 7:
                      v = v?removeHtml(v):'';
                      v = v.length>30?v.substr(0,30):v;
                      break;
                   case 12:
                      v = v?v.XingMing:'';
                       break;
                   case 2:
                   case 13:
                       v = v?v.statusName:'';
                      break;
                   default:

                 }
               key[ii] = ii < 2 ? v : keys[ii].primaryText + " : " + v ;
             }
             for(let i=0;i<10;i++){
                if (key[i] && key[i].indexOf('undefined')>=0) key[i] = key[i].replace(/undefined/ig,'');
                if (key[i] && key[i].indexOf('null')>=0) key[i] = key[i].replace(/null/ig,'');
             }


             const attachmentColumn = currentColumns.find(x => x.pTypeId==11);

             item.section = {
               ID: 0,
               type:'list-item-n',
               itemClass:'',
               class: ''
             };

             if (attachmentColumn){
               Object.assign(item, {
                  url: [item['__c'+attachmentColumn.ID] && item['__c'+attachmentColumn.ID].FilePath?item['__c'+attachmentColumn.ID].FilePath:'/images/loading.png'],
               });
             }

             const viewPageId = this.getOption('viewPageId');

         

             Object.assign(item, {
                   viewPageId: viewPageId,
                   pageType: 8,
         //      url: [item.__c81.FilePath],
                   decorate: true,
                   primaryText:  key[0] ,
                   primaryClass:'text-lg  flex text-l-1',
                   secondaryText: key[1],
                   secondaryClass: 'text-sm m-t-sm  text-l-1 padder-l',
                   primaryText1: key[2],
                   primaryClass1: 'padder-l-sm w-50-b text-sm m-t-sm  text-l-1',
                   secondaryText1: key[3],
                   secondaryClass1: 'w-50-b text-sm m-t-sm  text-l-1 padder-l',
                   primaryText2: key[4],
                   primaryClass2: 'padder-l-sm w-50-b text-sm m-t-sm  text-l-1',
                   secondaryText2: key[5],
                   secondaryClass2: 'w-50-b text-sm m-t-sm  text-l-1 padder-l',
                   primaryText3: key[6],
                   primaryClass3: 'padder-l-sm w-50-b text-sm m-t-sm  text-l-1',
                   secondaryText3: key[7],
                   secondaryClass3: 'w-50-b text-sm m-t-sm  text-l-1 padder-l',
                   primaryText4: key[8],
                   primaryClass4: 'padder-l-sm w-50-b text-sm m-t-sm  text-l-1',
                   secondaryText4: key[9],
                   secondaryClass4: 'w-50-b text-sm m-t-sm  text-l-1 padder-l'
             });

          }
        }
      }
    }
  },
  onShow() {

  },
  onLoad() {


  }
}]);

Page(getPage(ListDataMixin, {
}));
