import { list, loading, roundprocess, swiper } from '../../polaris/polaris';

import config from '../../config/config';
import editableListMixin from '../../module/editableListMixin';
import { fixImagePath } from '../../utils/utils';
import getPage from '../../module/page';
import mixin from '../../utils/mixin';
import regeneratorRuntime from '../../lib/regenerator-runtime/runtime';
import request from '../../config/request';
import viewpage from '../../module/viewpage';
import storage from '../../utils/storage';

const DashMixin = mixin(viewpage, [
    {
        fetchOnEnter: false,
        data: {
            canIUse: wx.canIUse('button.open-type.getUserInfo')
        },
        updateRedux({ login }) {
            if (this.redux.login !== login) {
                if (login.logining) {
                    this.loginlogin = true;
                    this.emit('showLoading', this.page);
                } else if (this.loginlogin) {
                    this.loginlogin = false;
                    if (login.error) {
                        let message = '登录失败,请稍后重试';
                        if (login.error.code === 'ECONNABORTED') {
                            message = '请求超时,请检查您的网络环境';
                        } else if (login.error.message) {
                            message = login.error.message;
                        }
                        this.emit('hideLoading', this.page, message + '登录失败,请稍后重试', true);
                    } else {
                        this.emit('hideLoading', this.page);
                        // console.log(this.options);
                        if (this.options.preRouter) {
                            if (this.options.navType === 'tab') {
                                wx.switchTab({
                                    url: this.options.preRouter
                                });
                            } else {
                                this.itemNav({
                                    router: this.options.preRouter,
                                    redirect: this.options.navType === 'redirect'
                                });
                            }
                        } else {
                            wx.navigateBack();
                        }
                        this.emit('loginSuccess');
                        // wx.switchTab({ url: '/pages/dash/index' });
                    }
                }
            }
        },
        methods: {
            cancelAuth() {
                wx.navigateBack();
            },
            getUserInfo(info) {
                if (info.detail.errMsg === 'getUserInfo:ok') {
                    this.redux.loginAction();
                }
            }
        },
        onLoad() {
            this.getSystemInfo();

            // 查看是否授权
            wx.getSetting({
                success: (res) => {
                    if (res.authSetting['scope.userInfo']) {
                        this.redux.loginAction();
                    }
                }
            });
        }
    }
]);

Page(getPage(DashMixin));
