import { GetRound, fixImagePath } from '../../utils/utils';
import { list, xnumber } from '../../polaris/polaris';

import getPage from '../../module/page';
import listpage from '../../module/listpage';
import mixin from '../../utils/mixin';
import request from '../../config/request';
import { updateParams } from '../../redux/params';

const cartList2 = mixin(list, [
  {
    checkType: 'check',
    data: {
      checkType: 'check',
    },
    customModifyItem(item) {
      item.section = {
        ID: 0,
        type: 'list-goods',
        header: {
          type: 'header2',
          title: '门店',
          groupCheck: true,
          edit: false,
          subTitle: '编辑'
        }
      };
      //__c196
      item.id = 'delete';
      item.primaryText = item.__c61;
      item.url = fixImagePath(item.__c65.FilePath);
      item.price = item.__c64;
      item.number = item.__c197;
      item.__c318 = item.__c316.ID;
      item.__c319 = item.__c317.ID;
      item.__c193 = item.server_identity;
      item.__c187 = item.price;
      item.__c188 = item.number;
      item.__c189 = item.__c196;
      item.secondaryText = `颜色: ${item.__c316.statusName}; 尺寸: ${item.__c317.statusName}`;
      item.columns = [
        {
          ID: 'number',
          eid: 'number',
          component: {
            component: 'xnumber'
          }
        }
      ]
    }
  }
])

const CartMixin = mixin(listpage, [{
  reduxDispatch: { updateParams },
  checkAll: false,
  components: {
    list: cartList2
  },
  onLoad() {
    this.updateFooter();
    this.on('checkable-tap', this.onListCheck);
    this.coms.footer.setData({
      edit: {
        id: 'edit',
        label: '编辑'
      }
    });
  },
  onListCheck(scope, items) {
    if (this.getChildEventScope(scope) === 'list') {
      this.updateFooter();
    }
  },
  updateFooter() {
    const allItems = this.coms.list.getData().items || [];
    this.checkAll = allItems.length > 0 && allItems.findIndex(item => !item.checked) < 0;

    let totalAmt = 0;
    let totalCnt = 0;
    const items = this.coms.list.getSelectedItems();
    items.forEach(item => {
      totalCnt += item.number;
      totalAmt += item.price * item.number;
    });

    this.coms.footer.setData({
      allCheck: {
        id: 'allCheck',
        label: this.checkAll ? '全不选' :'全选'
      },
      submit: {
        id: 'submit',
        label: `结算(${totalCnt})`
      },
      info: {
        amt: totalAmt.toFixed(2)
      }
    });
  },
  methods: {
    moreButtonClicked(button, data) {
      if (button.id === 'allCheck') {
        setTimeout(()=>{
          const data = this.getData();
          this.checkAll = !this.checkAll;
          this.coms.list.checkAllItem(this.checkAll);
          this.updateFooter();
        }, 20);
      } else if (button.id === 'submit') {
        const goods = this.coms.list.getSelectedItems();
        if (goods.length < 1) {
          this.emit('showToptip', this.page, { icon: 'warn', text: '您还没有选择任何商品'});
        } else {
          this.redux.updateParams({ type: 'cart', data: goods });
          this.navigateTo('/pages/settle/index');
        }
      } else if (button.id === 'edit') {
        const data = this.coms.list.getData();
        this.coms.footer.setData({
          edit: {
            id: 'edit',
            label: !data.edit ? '编辑' : '完成'
          }
        });
        this.coms.list.setData({
          edit: !data.edit
        });
      } else if (button.id === 'delete') {
        const items = data ? [data] : this.coms.list.getSelectedItems();
        request.deleteBuy(this, items);
      }
    }
  }
}]);

Page(getPage(CartMixin, {
  pageId: 118
}));
