import { fixImagePath } from '../../utils/utils';
import getPage from '../../module/page';
import {list} from '../../polaris/polaris';
import listMoreButtons from '../../module/listMoreButtons';
import listpage from '../../module/listpage';
import mixin from '../../utils/mixin';
import request from '../../config/request';

const goodsBtns = [
  {
    id: 'delete',
    label: '删除',
    icon: 'icon-trash'
  }
];

const MyCollectMixin = mixin(listpage, [
  {
    components: {
      list: {
        component: list,
        options() {
          return {
            moreButtons: goodsBtns,
            customModifyItem(item) {
              item.section = {
                ID: 0,
                type: 'grid-card',
                follow: true,
                bodyClass: 'padder-half',
                tipClass: 'text-muted',
                header: {
                  type: 'header2',
                  title: '2017-01-01',
                  icon: 'icon-clock',
                  class: 'b-t bg-white',
                  // subIcon: 'fa fa-trash-o'
                }
              };
              // __c204
              item.primaryText = item.__c61;
              item.url = item.__c65 ? fixImagePath(item.__c65.FilePath) : '';
              item.price = item.__c64;
              item.follow = true;
            }
          };
        }
      }
    },
    methods: {
      moreButtonClicked(button, data) {
        let items = data
          ? [data]
          : this
            .coms
            .list
            .getSelectedItems();
        if (button.id === 'delete') {
          request.deleteCollect(this, items);
        }
      }
    },
    extendModeButtons(button) {
      const buttons = listMoreButtons.extendModeButtons(this, button);
      buttons.push(...goodsBtns);
      return buttons;
    }
  }
]);

Page(getPage(MyCollectMixin, { pageId: 125 }));
