import {  tab, list } from '../../polaris/polaris';

import getPage from '../../module/page';
import listMoreButtons from '../../module/listMoreButtons';
import listpage from '../../module/listpage';
import viewpage from '../../module/viewpage';
import commonPage from '../../module/commonPage';
import mixin from '../../utils/mixin';
import storage from '../../utils/storage';
import { removeHtml, formatDate,  fixImagePath,wrapRow ,groupBy } from '../../utils/utils';
import request from '../../config/request';
import wxCharts from '../../config/wxcharts-min.js' ;


const CustomerMixin = mixin(commonPage, [{
  mustLogin:true,
  data: {
          chartTitle: '总成交量',
          isMainChartDisplay: true,
          columnChart:null,
          chartData:{},
          lineVisible:false,
          columnVisible:false,
          canvas:'canvas'
      },
  components: {
    list: {
      component: list,
    },
    tab: {
            component: tab,
             options() {
              return {
                data: {
                  className: 'w-full z-2 bg-white'
                }
              };
            }
          },
  },
    methods: {
      touchHandler2: function (e) {
          var stat = this.getData();
          // console.log(stat.lineChart.getCurrentDataIndex(e));
          // stat.lineChart.showToolTip(e, {
          //     // background: '#7cb5ec',
          //     format: function (item, category) {
          //         return category + ' ' + item.name + ':' + item.data
          //     }
          // });
      },
      touchHandler: function (e) {
           var stat = this.getData();
        //   stat.columnChart.scrollStart(e);
       },
       moveHandler: function (e) {
         var stat = this.getData();
        //   stat.columnChart.scroll(e);
       },
       touchEndHandler: function (e) {
           var stat = this.getData();
           // stat.columnChart.scrollEnd(e);
           // stat.columnChart.showToolTip(e, {
           //     format: function (item, category) {
           //         return category + ' ' + item.name + ':' + item.data
           //     }
           // });
       },
      createServiceData: function (rdata,rcount) {
        var categories = [];
        var data = [];

       rdata.forEach( (i,j)=> {
             categories.push('第' + i.week + '周');
             data.push(i.ccount / rcount );
        });

        // for (var i = 0; i < 10; i++) {
        //     categories.push('2016-' + (i + 1));
        //     data.push(Math.random()*(20-10)+10);
        // }
        // data[4] = null;
        return {
            categories: categories,
            data: data
        }
    },
            createSimulationData: function (rdata,rcount) {
              var categories = [];
              var data = [];

             rdata.forEach( (i,j)=> {
                   categories.push('第' + i.week + '周');
                   data.push(i.ccount / rcount );
              });
              return {
                  categories: categories,
                  data: data
              }
          } ,

    },
    fetchListOnEnter:false,

    tab1(){

      const that = this;
      var windowWidth = this.getData().windowWidth;

      var d1 =  new Date() ;//formatDate(new Date(), 'yyyy-MM-dd')
      d1.setMonth(d1.getMonth()-1);
      var dd1 = new Date(d1.getFullYear() , d1.getMonth(), 1)

    //  var sc = {'_Key':'__c18601','_Value':'467634ae-2dd9-46c2-a123-6439563f5c43'};
      var lsc =[];
    //  lsc.push(sc);
      lsc.push({'_Key':'__c18602x1','_Value':formatDate(dd1, 'yyyy-MM-dd')});
      lsc.push({'_Key':'__c18602x2','_Value':formatDate(new Date(), 'yyyy-MM-dd')});
     const sections =[];


       that.setData({
         columnVisible:false,
         lineVisible:true
       });

      // request.fetchSaleAnalytic(this,lsc,function(ret){

       let t1 =[{Column1:4}];
       let t2 =[{Column1:5}];
       let t3 =[{Column1:6}];
       let t4 =[{week:2,ccount:4}];
       let t5 =[{week:2}];
       let t6 =[{Column1:7}];

         sections.push(
           {
             ID: 1,
             type: 'grid-overlay',
             itemClass: 'col-xs-4 m-b-sm padder-v bg-white',
             class: 'm-b-sm  bg-white',
             viewClass: 'b  ',
             header: {
               type: 'header2',
               title: '采购统计 · 2020-01-01  到  ' +  formatDate(new Date(), 'yyyy-MM-dd'),
               titleClass : '',
               subTitle: '',
               subClass: 'text-xs text-blue',
               subIcon2: 'fa fa-angle-right text-blue',
               class: 'b-b bg-white',
             },

             items: [
               {
                 primaryText  : '新增采购计划',
                 primaryText1 :  75,
                 primaryClass : 'text-md   m-b-sm c666',
                 primaryClass1 : 'text-md font-bold main-color'

               },
               {
                 primaryText  : '采购总额',
                 primaryText1 :  239.6,
                 primaryClass : 'text-md   m-b-sm c666',
                 primaryClass1 : 'text-md font-bold main-color'

               },
               {
                 primaryText  : '已付金额',
                 primaryText1 :  375.6,
                 primaryClass : 'text-md   m-b-sm c666',
                 primaryClass1 : 'text-md font-bold main-color'

               }
             ]
           });

           that.coms.list.updateItems(sections);


           new wxCharts({
              canvasId: 'lineCanvas',
              type: 'line',
              categories: ['一月', '二月', '三月', '四月', '五月', '六月'],
              series: [{
                  name: '已付金额',
                  data: [15.0, 21.5, 45.3, 37.0, 40.3, 80.5],
                  format: function (val) {
                      return val.toFixed(2) + '万';
                  }
              }, {
                  name: '采购总额',
                  data: [30.5, 37.2, 65.7, 78.4, 69.5, 94.3],
                  format: function (val) {
                      return val.toFixed(2) + '万';
                  }
              }],
              yAxis: {
                  title: '成交金额 (万元)',
                  format: function (val) {
                      return val.toFixed(2);
                  },
                  min: 0
              },
              width: 320,
              height: 200
          });

          //  var my_v =[];
          //  t5.forEach((i,j) => {
          //
          //    var it =  t4.find(item => item.week==i.week) ;
          //    if (it) {
          //      my_v.push(it.ccount)
          //    } else {
          //      my_v.push(0);
          //    }
          //
          // });

           //
           // var simulationData = that.createSimulationData(t5,t6['Column1']);
           //   console.log(simulationData);
           //  var  lineChart = new wxCharts({
           //       canvasId: 'lineCanvas',
           //       type: 'line',
           //       categories: simulationData.categories,
           //       animation: true,
           //       // background: '#f5f5f5',
           //       series: [{
           //           name: '平均',
           //           data: simulationData.data,
           //           format: function (val, name) {
           //               return val.toFixed(2) + '';
           //           }
           //       }
           //
           //       , {
           //           name: '我的',
           //           data: my_v,
           //           format: function (val, name) {
           //               return val.toFixed(2) + '';
           //           }
           //       }
           //
           //     ],
           //       xAxis: {
           //           disableGrid: true
           //       },
           //       yAxis: {
           //           title: '周日报数量比对',
           //           format: function (val) {
           //               return val.toFixed(2);
           //           },
           //           min: 0
           //       },
           //       width: 375,
           //       height: 200,
           //       dataLabel: false,
           //       dataPointShape: true,
           //       extra: {
           //           lineStyle: 'curve'
           //       }
           //   });
           //
           //   that.setData({
           //     lineChart:lineChart,
           //     simulationData: simulationData
           //   });

       //});

       console.log('tttx');




    },

    tab2(){

      const that = this;
      var windowWidth = this.getData().windowWidth;

      var d1 =  new Date() ;//formatDate(new Date(), 'yyyy-MM-dd')
      d1.setMonth(d1.getMonth()-1);
      var dd1 = new Date(d1.getFullYear() , d1.getMonth(), 1)

      const sections =[];


            //   var sc2 = {'_Key':'__c18601','_Value':'56f53fcc-ad55-48e7-afd5-7e07ece1e402'};
               var lsc2 =[];
          //     lsc2.push(sc2);
               lsc2.push({'_Key':'__c18602x1','_Value':formatDate(dd1, 'yyyy-MM-dd')});
               lsc2.push({'_Key':'__c18602x2','_Value':formatDate(new Date(), 'yyyy-MM-dd')});

                 that.setData({
                   columnVisible:true,
                   lineVisible:false
                 });

        //         request.fetchServiceAnalytic(this,lsc2,function(ret){

                  // console.log(ret.data);

                   sections.push(
                     {
                       ID: 1,
                       type: 'grid-overlay',
                       itemClass: 'col-xs-4 m-b-sm padder-v bg-white',
                       class: 'm-b-sm  bg-white',
                       viewClass: 'b',
                       header: {
                         type: 'header2',
                         title: '销售统计 · ' + '2020-01-01' + ' 到 ' + '2017-7-01',
                         titleClass : '',
                         subTitle: '',
                         subClass: 'text-xs text-blue',
                         subIcon2: 'fa fa-angle-right text-blue',
                         class: 'b-b bg-white',
                       },

                       items: [
                         {
                           primaryText  : '新增订单',
                           primaryText1 :  63,// ret.data[0][0]['Column1']? ret.data[0][0]['Column1']:'0',
                           primaryClass : 'text-md   m-b-sm c666',
                           primaryClass1 : 'text-md font-bold main-color'

                         },
                         {
                           primaryText  : '销售总额',
                           primaryText1 :  328.8 ,//ret.data[5][0]['Column1'],
                           primaryClass : 'text-md   m-b-sm c666',
                           primaryClass1 : 'text-md font-bold main-color'
                         },
                         {
                           primaryText  : '回款总额',
                           primaryText1 :  202.1 ,//ret.data[1][0]['Column1'],
                           primaryClass : 'text-md   m-b-sm c666',
                           primaryClass1 : 'text-md font-bold main-color'

                         }
                       ]
                     });

                     that.coms.list.updateItems(sections);

                     new wxCharts({
                          canvasId: 'columnCanvas',
                          type: 'column',
                          categories: ['一月', '二月', '三月', '四月', '五月', '六月'],
                          series: [{
                              name: '回款金额',
                              data: [15.3, 20.5, 45.0, 37.2, 4.0, 80.1]
                          }, {
                              name: '订单总额',
                              data: [70.7, 40.4, 65.0, 100.5, 34.2, 18.0]
                          }],
                          yAxis: {
                              format: function (val) {
                                  return val + '万';
                              }
                          },
                          width: 320,
                          height: 200
                      });

                      //     that.setData({
                      //       lineChart:lineChart,
                      //       simulationData: ServiceData
                      //     });




                    //  var my_v2 =[];
                    //  ret.data[3].forEach((i,j) => {
                    //
                    //    var it =  ret.data[2].find(item => item.week==i.week) ;
                    //    if (it) {
                    //      my_v2.push(it.ccount)
                    //    } else {
                    //      my_v2.push(0);
                    //    }
                    //
                    // });
                    //
                    // var ServiceData = that.createServiceData(ret.data[3],ret.data[4][0]['Column1']);
                    //  console.log(ServiceData);
                    //
                    //
                    //
                    //  var  lineChart  =  new wxCharts({
                    //       canvasId: 'lineCanvas',
                    //       type: 'line',
                    //       categories: ['一', '二','三','四','五','六','日'],
                    //       series: [{
                    //           name: '考勤',
                    //           data: [30,36, 42, 40,33, 30,6],
                    //           format: function (val) {
                    //               return val.toFixed(2) + '次';
                    //           }
                    //       }, {
                    //           name: '日报',
                    //           data: [24, 26, 24, 36, 30, 31,12],
                    //           format: function (val) {
                    //               return val.toFixed(2) + '次';
                    //           }
                    //       }],
                    //       xAxis: {
                    //           disableGrid: true
                    //       },
                    //       yAxis: {
                    //           title: '周日报数量比对',
                    //           format: function (val) {
                    //               return val.toFixed(2);
                    //           },
                    //           min: 0
                    //       },
                    //       width: 375,
                    //       height: 200,
                    //       dataLabel: false,
                    //       dataPointShape: true,
                    //   });
                    //
                    //
                    //     that.setData({
                    //       lineChart:lineChart,
                    //       simulationData: ServiceData
                    //     });

                     //
                     // console.log(ServiceData);
                     //
                     //
                     //
                     //  var  lineChart = new wxCharts({
                     //       canvasId: 'lineCanvas',
                     //       type: 'line',
                     //       categories: ServiceData.categories?ServiceData.categories:['2019'],
                     //       animation: true,
                     //       // background: '#f5f5f5',
                     //       series: [{
                     //           name: '平均',
                     //           data: ServiceData.data?ServiceData.data:[1],
                     //           format: function (val, name) {
                     //               return val.toFixed(2) + '';
                     //           }
                     //       }
                     //
                     //       , {
                     //           name: '我的',
                     //           data: my_v2,
                     //           format: function (val, name) {
                     //               return val.toFixed(2) + '';
                     //           }
                     //       }
                     //
                     //     ],
                     //       xAxis: {
                     //           disableGrid: true
                     //       },
                     //       yAxis: {
                     //           title: '周日报数量比对',
                     //           format: function (val) {
                     //               return val.toFixed(2);
                     //           },
                     //           min: 0
                     //       },
                     //       width: 375,
                     //       height: 200,
                     //       dataLabel: false,
                     //       dataPointShape: true,
                     //       extra: {
                     //           lineStyle: 'curve'
                     //       }
                     //   });
                     //
                     //   that.setData({
                     //     lineChart:lineChart,
                     //     simulationData: ServiceData
                     //   });

            //     });



    },
    tab3(){

      const that = this;
      var windowWidth = this.getData().windowWidth;


     const sections =[]
                 that.setData({
                   columnVisible:true,
                   lineVisible: false
                 });

                 request.fetchManageAnalytic(this,[],function(ret){

                   sections.push(
                     {
                       ID: 1,
                       type: 'grid-overlay',
                       itemClass: 'col-xs-4 m-b-sm padder-v bg-white',
                       class: 'm-b-sm  bg-white',
                       viewClass: 'b ',
                       header: {
                         type: 'header2',
                         title: '管理统计',
                         titleClass : '',
                         subTitle: '',
                         subClass: 'text-xs text-blue',
                         subIcon2: 'fa fa-angle-right text-blue',
                         class: 'b-b bg-white',
                       },

                       items: [
                         {
                           primaryText  : '昨天销售日报',
                           primaryText1 :  ret.data[0][0]['Column1']? ret.data[0][0]['Column1']:'0',
                           primaryClass : 'text-md  m-b-sm c666',
                           primaryClass1 : 'text-md font-bold main-color'


                         },
                         {
                           primaryText  : '昨天客服日报',
                           primaryText1 :  ret.data[1][0]['Column1'],
                            primaryClass : 'text-md  m-b-sm c666',
                            primaryClass1 : 'text-md font-bold main-color'

                         },
                         {
                           primaryText  : '昨天考勤人数',
                           primaryText1 :  ret.data[2][0]['Column1'],
                            primaryClass : 'text-md   m-b-sm c666',
                            primaryClass1 : 'text-md font-bold main-color'

                         }
                         ,
                         {
                           primaryText  : '今日天考勤人数',
                           primaryText1 :  ret.data[3][0]['Column1']?ret.data[3][0]['Column1']:'0',
                            primaryClass : 'text-md   m-b-sm c666',
                            primaryClass1 : 'text-md font-bold main-color'

                         }
                         ,
                         {
                           primaryText  : '昨日加班人数',
                           primaryText1 :  ret.data[4][0]['Column1'],
                            primaryClass : 'text-md   m-b-sm c666',
                            primaryClass1 : 'text-md font-bold main-color'

                         }
                         ,
                         {
                           primaryText  : '本月活跃项目数',
                           primaryText1 :  ret.data[5][0]['count'],
                            primaryClass : 'text-md   m-b-sm c666',
                            primaryClass1 : 'text-md font-bold main-color'

                         }
                       ]
                     });

                     var manage_categories =[];
                     var manage_data = ret.data[6];
                     var manage_data1 =[];
                     var manage_data2 =[];
                     manage_data.sort(function(obj1,obj2){
                         return obj1.total_hours -obj2.total_hours
                     });
                     manage_data.reverse();
                     manage_data.forEach((i,j)=>{

                         if (j<20)
                         {

                           manage_categories.push(i.project);
                           manage_data1.push(i.total_hours);
                           manage_data2.push(i.total_hours/i.active_users);
                         }

                     });
                     var t = groupBy(manage_data,'active_users');

                     var ring_data =[];
                     Object.keys(t).forEach((i,j)=>{
                         var row ={};
                         var total =0;
                         row.name = '人数·' +i;

                         t[i].forEach((p,q)=>{
                            total += p.total_hours;
                         });
                         row.data = total;
                         ring_data.push(row);

                     });





                     that.coms.list.updateItems(sections);


                         var columnChart = new wxCharts({
                           canvasId: 'columnCanvas',
                           type: 'column',
                           animation: true,
                           categories: manage_categories,
                           series: [{
                               name: '总计',
                               data: manage_data1,
                               format: function (val, name) {
                                   return val.toFixed(0) ;
                               }
                           },
                           {
                               name: '人均',
                               data: manage_data2,
                               format: function (val, name) {
                                   return val.toFixed(0) ;
                               }
                           }

                         ],
                           yAxis: {
                               format: function (val) {
                                   return val  ;
                               },
                               title: '本月项目工时统计',
                               min: 0
                           },
                           xAxis: {
                               disableGrid: false,
                               type: 'calibration'
                           },
                           extra: {
                               column: {
                                   width: 15
                               }
                           },

                           enableScroll: true,
                           width: windowWidth,
                           height: 200,
                       });

                       that.setData({columnChart : columnChart});



                       var     pieChart = new wxCharts({
                         animation: true,
                             canvasId: 'pieCanvas',
                             type: 'ring',
                             extra: {
                                 ringWidth: 25,
                                 pie: {
                                     offsetAngle: -45
                                 }
                             },
                                series: ring_data ,
                                width: windowWidth,
                                height: 300,
                                dataLabel: true,
                            });





                 });



    },
    tabChanged(scope, item, selected, toggle) {

    if (this.getChildEventScope(scope) === 'tab') {

         if (item.type=="sale")
         {
            this.tab1();
         }

         if (item.type=="service")
         {
            this.tab2();
         }

         if (item.type=="manage")
         {
            this.tab2();
         }






          // this.updatePageInfo(item);
          // this.coms.list.refresh();
        }
      },
    onLoad: function (e) {

      const types = [
        {
          title: '采购统计',
          key: 'sale',
          type: 'sale',
          pageId : 41,
          lsc: [ ] //status
        },
        {
          title: '销售统计',
          key: 'service',
          type: 'service',
          pageId : 41,
          lsc: [] //status
        }];

        this.coms.tab.setData({
            list: types,
            selectedId: 0,
            scroll: false
          });
          this.on('tabChanged', this.tabChanged);


           storage.getItem('userData',function(error){
           }).then((userData)=>{

            // return false;



               if (userData.RoleIds.toLowerCase().indexOf('b150d808-17b6-4159-b525-73b3f3382b6e')>=0)
               {
                 this.coms.tab.setData({
                     selectedId: 2,
                   });
                     setTimeout(()=>{
                     this.tab2();
                     },300);

               }
               else if(userData.RoleIds.toLowerCase().indexOf('16dcb45f-daaa-4cde-8335-4b6bead3ff85')>=0)
               {
                 this.coms.tab.setData({
                     selectedId: 0,
                   });
                   setTimeout(()=>{
                     this.tab2();
                   },300);

               }
               else {
                 this.coms.tab.setData({
                     selectedId: 1,
                   });


                   setTimeout(()=>{
                      this.tab2();
                   },300);
               }


           });







          var windowWidth = 375;

            var res = wx.getSystemInfoSync();
            windowWidth = res.windowWidth;
              console.log('system width :' + windowWidth);

              // if (windowWidth>320){
              //   this.setData({ canvas:
              //     'canvas1'
              //   });
              // }






        },




      onReady: function (e) {






      }

}]);

Page(getPage(CustomerMixin, {
  pageId: 9836
}));
