import { list, singlefiltertab } from '../../polaris/polaris';

import { fixImagePath } from '../../utils/utils';
import getPage from '../../module/page';
import listpage from '../../module/listpage';
import log from '../../utils/log';
import mixin from '../../utils/mixin';
import request from '../../config/request';

const MyOrderMixin = mixin(listpage, [{
  components: {
    list: {
      component: list,
      options() {
        return {
          customModifyItem(item) {
            // 每行一个group, related明细做为Item
            const buttons = [];
            if (item.__c172.ID === 5) {
              buttons.push({
                id: 'applyCancelOrder',
                label: '取消订单'
              });
              buttons.push({
                id: 'payOrder',
                label: '立即付款',
                class: 'btn btn-danger no-bg btn-sm m-l-sm'
              });
            } else if (item.__c172.ID === 7) {
              buttons.push({
                id: 'confirmOrder',
                label: '确认收货',
                class: 'btn btn-danger no-bg btn-sm m-l-sm'
              });
            } else if (item.__c172.ID === 8 || item.__c172.ID === 10) {
              buttons.push({
                id: 'deleteOrder',
                label: '删除订单'
              });
            }

            let totalAmt = 0;
            let totalCnt = 0;
            const items = [];
            item.related[0].list.forEach(i => {
              items.push({
                primaryText: i.__c61,
                url: fixImagePath(i.__c65.FilePath),
                price: i.__c187,
                secondaryText: `颜色: ${i.__c318.statusName}; 尺寸: ${i.__c319.statusName}`,
                number: i.__c188,
                pageId: 107,
                __c161: item.__c161
              });
              totalCnt += i.__c188;
              totalAmt += i.__c187 * i.__c188;
            });
            item.items = items;

            item.section = Object.assign({}, item, {
              ID: item.__c161,
              relatedAsItems: true, // related数据作为item的标志，刷新时需要
              type: 'list-goods',
              class: 'm-t-sm',
              header: {
                type: 'header2',
                // url: 'https://file3.bizsaas.com/files/2028/2017721/c263204f-d5de-45b6-a39c-cee4845b75f9.JPG',
                title: '门店',
                subTitle: item.__c172.statusName,
                subClass: 'text-base text-black',
                titleClass: 'font-normal',
              },
              footer: {
                parts: [
                  {
                    type: 'footer3',
                    class: 'bg-white',
                    primaryText: `共${totalCnt}件商品`,
                    secondaryText: '合计:',
                    tertiaryText: `¥ ${totalAmt.toFixed(2)}`
                  }
                ]
              }
            });
            if (buttons.length > 0) {
              item.section.footer.parts.push({
                type: 'footer4',
                class: 'b-t bg-white',
                buttons,
                __c161: item.__c161
              });
            }
          }
        };
      }
    },
    singlefiltertab
  },
  methods: {
    moreButtonClicked(button, data) {
      const items = data ? [data] : this.coms.list.getSelectedItems();
      if (button.id === 'deleteOrder') {
        request.deleteOrder(this, items);
      } else if (button.id === 'confirmOrder') {
        request.confirmOrder(this, items[0]);
      } else if (button.id === 'applyCancelOrder') {
        request.applyCancelOrder(this, items[0]);
      } else if (button.id === 'payOrder') {
        request.obtainPay(this, items[0]);
      }
    }
  },
  onLoad() {
    this.coms.singlefiltertab.setColumn({
      ID: 172,
      pTypeId: 13,
      statusMap: [
        {
          ID: 5,
          primaryText: '待付款'
        },
        {
          ID: 6,
          primaryText: '待发货'
        },
        {
          ID: 7,
          primaryText: '待确认'
        },
        {
          ID: 8,
          primaryText: '已确认'
        },
        {
          ID: 9,
          primaryText: '申请取消'
        },
        {
          ID: 10,
          primaryText: '已取消'
        },
        {
          ID: 11,
          primaryText: '异常'
        }
      ]
    }, 0, true);

    this.coms.singlefiltertab.listview = this.coms.list;
  }
}]);

Page(getPage(MyOrderMixin, {
  pageId: 102
}));
