import { fixImagePath, formatDate } from '../../utils/utils';

import getPage from '../../module/page';
import { list } from '../../polaris/polaris';
import mixin from '../../utils/mixin';
import regeneratorRuntime from '../../lib/regenerator-runtime/runtime';
import request from '../../config/request';
import viewpage from '../../module/viewpage';

const ViewDataMixin = mixin(viewpage, [
    {
        components: {
            list: {
                component: list
            }
        },
        afterDetailFetched() {
            const item = this.detailData.data;
            const section = [];
            section.push({
                ID: 0,
                type: 'list-order-header',
                class: 'padder-v-md b-t bg-white',
                items: [
                    {
                        primaryText: item.__c172.statusName,
                        url: item.__c172.ID == 5 ? '/images/warning.png' : '/images/success.png'
                    }
                ]
            });

            let totalAmt = 0;
            let totalCnt = 0;
            const items = [];
            item.related[0].list.forEach((item) => {
                items.push({
                    primaryText: item.__c61,
                    url: fixImagePath(item.__c65),
                    price: item.__c187,
                    secondaryText: `颜色: ${item.__c318.statusName}; 尺寸: ${item.__c319.statusName}`,
                    number: item.__c188
                });
                totalCnt += item.__c188;
                totalAmt += item.__c187 * item.__c188;
            });

            section.push({
                ID: 1,
                type: 'list-goods',
                class: 'm-t-sm',
                header: {
                    type: 'header2',
                    title: '门店'
                },
                footer: {
                    parts: [
                        {
                            type: 'header2',
                            title: '商品总价',
                            subTitle: `¥ ${totalAmt.toFixed(2)}`,
                            titleClass: 'font-normal',
                            subClass: 'text-black',
                            class: 'b-b bg-white'
                        },
                        {
                            type: 'header2',
                            title: '订单总价',
                            subTitle: `¥ ${totalAmt.toFixed(2)}`,
                            subClass: 'text-black',
                            titleClass: 'font-normal',
                            class: 'b-b bg-white'
                        },
                        {
                            type: 'header2',
                            title: '实付款',
                            subTitle: `¥ ${totalAmt.toFixed(2)}`,
                            subClass: 'text-danger',
                            titleClass: 'font-normal'
                        }
                    ]
                },
                items
            });

            section.push({
                ID: 2,
                type: 'list-item2',
                class: 'm-t-sm padder-t-xs padder-b-xlg2 bg-white',
                itemClass: 'padder-t',
                items: [
                    {
                        primaryText: '订单编号',
                        secondaryText: item.__c183,
                        secondaryClass: 'm-l-sm flex text-muted'
                    },
                    {
                        primaryText: '交易号',
                        secondaryText: item.__c183,
                        secondaryClass: 'm-l-sm flex text-muted'
                    },
                    {
                        primaryText: '成交时间',
                        secondaryText: formatDate(item.__c175, 'yyyy-MM-dd'),
                        secondaryClass: 'm-l-sm flex text-muted'
                    }
                ]
            });

            this.coms.list.updateItems(section);

            const smallButtons = [];
            if (item.__c172.ID === 5) {
                smallButtons.push({
                    id: 'applyCancelOrder',
                    label: '取消订单'
                });
                smallButtons.push({
                    id: 'payOrder',
                    label: '立即付款',
                    class: 'btn btn-danger no-bg btn-sm m-l-sm'
                });
            } else if (item.__c172.ID === 7) {
                smallButtons.push({
                    id: 'confirmOrder',
                    label: '确认收货',
                    class: 'btn btn-danger no-bg btn-sm m-l-sm'
                });
            } else if (item.__c172.ID === 8 || item.__c172.ID === 10) {
                smallButtons.push({
                    id: 'deleteOrder',
                    label: '删除订单'
                });
            }

            this.coms.footer.dataset = { __c161: item.__c161 };
            this.coms.footer.setData({
                smallButtons
            });
        },
        methods: {
            moreButtonClicked(button, data) {
                const items = data ? [ data ] : this.coms.list.getSelectedItems();
                if (button.id === 'deleteOrder') {
                    request.deleteOrder(this, items);
                } else if (button.id === 'confirmOrder') {
                    request.confirmOrder(this, items[0]);
                } else if (button.id === 'applyCancelOrder') {
                    request.applyCancelOrder(this, items[0]);
                } else if (button.id === 'comment') {
                    this.itemNav({
                        pageId: 32
                    });
                } else if (button.id === 'payOrder') {
                    request.obtainPay(this, items[0]);
                }
            }
        }
    }
]);

Page(getPage(ViewDataMixin));
