import { dateStr, formateDate } from '../../utils/dateUtils';
import { fixImagePath, removeHtml } from '../../utils/utils';
import { footer, list } from '../../polaris/polaris';

import fetchListMixin from '../../module/fetchListMixin';
import getPage from '../../module/page';
import mixin from '../../utils/mixin';
import regeneratorRuntime from '../../lib/regenerator-runtime/runtime';
import request from '../../config/request';
import viewpage from '../../module/viewpage';

const ViewDataMixin = mixin(viewpage, [fetchListMixin, {
  fetchListOnEnter: false,
  components: {
    list: {
      component: list,
      options() {
        return {
          pageId: 34,
          customModifyItem(item) {
            item.section = {
              ID: 0,
              type: 'list-comment'
            };
            item.user = item.__c52;
            item.time = formatDate(item.__c54, 'yyyy-MM-dd hh:mm');
            item.content = removeHtml(item.__c53);
          }
        };
      }
    },
    footer: {
      component: footer,
      options() {
        return {
          extendModeButtons: this.extendModeButtons.bind(this),
          updateButtons: this.updateButtons.bind(this),
          methods: {
            handleShowComment(e) {
              this.setData({
                showComment: true
              });
            },
            handleHideComment(e) {
              this.setData({
                showComment: false
              });
            },
            handleUpdateComment(e) {
              const data = this.getData();
              request.sendComment(this, { ID: data.ID, content: data.comment });
              this.setData({
                showComment: false
              });
            },
            handleComment(e) {
              this.setData({
                comment: e.detail.value
              });
            }
          }
        };
      }
    }
  },
  customModifyItem(item) {
    item.user = item.__c81.XingMing;
    item.time = dateStr(item.__c85);
    item.content = removeHtml(item.__c86);
    item.url = item.__c82.map(i =>  fixImagePath(i));
  },
  methods: {
    moreButtonClicked(button) {

    }
  },
  updateButtons() {
    return [{
      id: 'like',
      icon: 'fa fa-thumbs-o-up'
    },{
      id: 'dislike',
      icon: 'fa fa-thumbs-o-down'
    }];
  },
  updateRedux() {
    const item = this.detailData.data;
    if (item && item.server_identity) {
      this.coms.footer.setData({
        ID: item.server_identity
      });
    }
  }
}]);

Page(getPage(ViewDataMixin));
