import getPage from '../../module/page';
import list from '../../polaris/list/list';
import listpage from '../../module/listpage';
import mixin from '../../utils/mixin';
import request from '../../config/request';

const OftenMixin = mixin(listpage, [{
  components: {
    list: {
      component: list,
      options() {
        return {
          methods: {
            handleDeleteOften(e) {
              request.deleteOften(this, [this.getTapItem(e)]);
            },
            handleDefaultOften(e) {
              request.topOften(this, this.getTapItem(e));
            }
          }
        };
      }
    }
  }
}]);

Page(getPage(OftenMixin, {
  pageId: 172
}));
