import { list, singlefiltertab } from '../../polaris/polaris';

import getPage from '../../module/page';
import listpage from '../../module/listpage';
import mixin from '../../utils/mixin';
import request from '../../config/request';

const OrderMixin = mixin(listpage, [{
  components: {
    list: {
      component: list,
      options() {
        return {
          methods: {
            handleSendOrder(e) {
              request.sendOrder(this, [this.getTapItem(e)]);
            },
            handleCancelOrder(e) {
              request.cancelOrder(this, [this.getTapItem(e)]);
            }
          }
        };
      }
    },
    singlefiltertab
  },
  onLoad() {
    this.coms.singlefiltertab.setColumn({
      ID: 55,
      pTypeId: 13,
      statusMap: [
        {
          ID: 5,
          primaryText: '待付款'
        },
        {
          ID: 6,
          primaryText: '待发货'
        },
        {
          ID: 7,
          primaryText: '待确认'
        },
        {
          ID: 8,
          primaryText: '已确认'
        },
        {
          ID: 9,
          primaryText: '申请取消'
        },
        {
          ID: 10,
          primaryText: '已取消'
        },
        {
          ID: 11,
          primaryText: '异常'
        }
      ]
    }, 0, true);

    this.coms.singlefiltertab.listview = this.coms.list;
  }
}]);

Page(getPage(OrderMixin, {
  pageId: 28
}));
