import {list, loading, roundprocess, swiper} from '../../polaris/polaris';

import config from '../../config/config';
import editableListMixin from '../../module/editableListMixin';
import { fixImagePath } from '../../utils/utils';
import getPage from '../../module/page';
import mixin from '../../utils/mixin';
import regeneratorRuntime from '../../lib/regenerator-runtime/runtime';
import request from '../../config/request';
import viewpage from '../../module/viewpage';
import storage from '../../utils/storage';
import { createUpdate } from '../../utils/request';

const DashMixin = mixin(viewpage, [
  {
    data:{
       mobile:'',
       vcode:'',
       pwd :'',
       scode:false,
    },
    delayEnter: null,
    components: {
      roundprocess : {
        component: roundprocess,
        options() {
          return {
            autoRun: 3000,
            radius: 40,
            displayText: false,
            data: {
            }
          };
        }
      }
    },
    fetchOnEnter: false,
    loginLoading: false,
    loginFailed(error) {
      return true;
    },
    updateRedux({ login, user }) {

    },
    methods: {
      dataChange(e){
         let name = e.currentTarget.dataset.name;
         let nameMap = {};
         nameMap[name] = e.detail && e.detail.value;
         this.setData(nameMap);

      },
      moreButtonClicked(button, item) {



        if (button.id==='validcode'){


          let itx = this.getData();
          let rmobile = /^\d{11}$/;
          if (!itx.mobile || !rmobile.test(itx.mobile) ||itx.scode ){
              wx.showModal({
                title: '提示',
                content: '手机号格式不对或验证码已满次数',
              });
             return false;
          }else{

             this.setData({scode: true});
          //   return false;

            createUpdate({
               pageId:543,
               itemId:0,
               jsonStr: [{ _Key: '__c692', _Value: itx.mobile } ]
            }).then(ret=>{
               if (ret.message == 'isv.BUSINESS_LIMIT_CONTROL') {
                  console.log('busy');
               } else{
                 wx.showModal({                 title: '提示',                 content: '验证码已发送',               });
               }
            });

          }
        }

        if (button.id==="updateAccount"){

          let itx = this.getData();
          let rmobile = /^\d{11}$/;
          if (!itx.mobile || !rmobile.test(itx.mobile)    ){
              wx.showModal({
                title: '提示',
                content: '手机号格式不对',
              });
             return false;
          }else{
            console.log(itx);
            //82784039-469f-40ec-b87b-e195d03b6df6   huozhu

              let RArray = [
                { _Key: '__c692', _Value: itx.mobile },
                { _Key: '__c694', _Value: itx.vcode },
                { _Key: '__c767', _Value: itx.pwd },
              ];
           //   return false;

           console.log(RArray);
      //     return false;

             createUpdate({
                pageId:543,
                itemId:0,
                jsonStr:  RArray
             }).then(ret=>{

                  wx.showModal({                 title: '提示',                 content:  ret.message ,               });

             },
            ret =>{
                wx.showModal({                 title: '提示',                 content:  ret.message ,               });
            }
           );



          }






        }




      },


    },
    onLoad() {
      this.getSystemInfo();
    },
    onReady() {


    }
  }
]);

Page(getPage(DashMixin, { pageId: 543 }));
