import { removeHtml } from '../../utils/utils';
import { dateStr } from '../../utils/dateUtils';
import { filtab, list, swiper } from '../../polaris/polaris';

import getPage from '../../module/page';
import mixin from '../../utils/mixin';
import regeneratorRuntime from '../../lib/regenerator-runtime/runtime';
import request from '../../config/request';
import viewpage from '../../module/viewpage';

const goodsBtns = [{
  id: 'collect',
  label: '收藏',
  icon: 'icon-star'
},
{
  id: 'buy',
  label: '购买',
  icon: 'icon-basket'
},
{
  id: 'import',
  label: '引入',
  icon: 'icon-action-redo'
}];

const StoreDetailMixin = mixin(viewpage, [{
  components: {
    recommend: {
      component: swiper
    },
    morerecommend: {
      component: swiper,
      options() {
        return {
          data: {
            sizeClass: 'height-large-ultra-wide',
            alignItems: 'items-start'
          }
        };
      }
    },
    category: list,
    hot: {
      component: list,
      options() {
        return {
          methods: {
            handleMoreTap(e) {
              const item = this.getTapItem(e);
              this.emit('showFollow', this.page, { e, item }, goodsBtns, this.scope);
            }
          }
        };
      }
    },
    new: {
      component: list,
      options() {
        return {
          methods: {
            handleMoreTap(e) {
              const item = this.getTapItem(e);
              this.emit('showFollow', this.page, { e, item }, goodsBtns, this.scope);
            }
          }
        };
      }
    },
    // allgoods: {
    //   component: pureGoods,
    //   options() {
    //     return {
    //       pageId: 20,
    //       categoryId: 4
    //     };
    //   }
    // },
    // filtab: {
    //   component: filtab,
    //   options() {
    //     return {
    //       pageId: 20
    //     };
    //   }
    // }
  },
  methods: {
    handleSearchInputChanged(e) {
      this.setData({
        searchInput: ''
      });
      this.navigateTo('/pages/goods/index', {
        searchInput: e.detail.value,
        lsc: [
          { patternId: 42, pTypeId: 23, operation: 1, val1: this.getData().item.__c14 }
        ]
      });
    },
    handleShowDetail(e){
      this.navigateTo('/pages/storedetail/storedetail', {
        item: this.getData().item
      });
    },
    moreButtonClicked(button, data) {
      const items = data ? [data] : this.coms.list.getSelectedItems();
      if (button.id === 'collect') {
        request.collectGoods(this, items);
      } else if (button.id === 'buy') {
        request.buyGoods(this, items);
      } else if (button.id === 'import') {
        request.importGoods(this, items);
      }
    }
  },
  updateRedux() {
    if (this.detailData.data && (!this.redux.detailData || this.detailData !== this.redux.detailData[this.getOption('pageId')])) {
      wx.setNavigationBarTitle({
        title: this.detailData.data.__c41
      });

      const recommend = this.detailData.data.related[1].list.filter(item => item.__c199.ID === 612).map(item => ({ url: item.__c196.FilePath, primaryText: item.__c300, secondaryText: item.__c197, router: item.__c301 }));
      this.coms.recommend.setData({
        items: recommend
      });
      const morerecommend = this.detailData.data.related[1].list.filter(item => item.__c199.ID === 614).map(item => ({ url: item.__c196.FilePath, primaryText: item.__c300, secondaryText: item.__c197, router: item.__c301 }));
      this.coms.morerecommend.setData({
        items: morerecommend
      });
      const category = this.detailData.data.related[1].list.filter(item => item.__c199.ID === 613).map(item => ({ url: item.__c196.FilePath, primaryText: item.__c300, secondaryText: item.__c197, router: item.__c301, icon: item.__c302 }));
      this.coms.category.updateItems([{ items: category }]);

      const hot = this.detailData.data.related[0].list.filter(item => item.__c303);
      this.coms.hot.updateItems([{ items: hot }]);

      const newgoods = this.detailData.data.related[0].list.filter(item => item.__c304);
      this.coms.new.updateItems([{ items: newgoods }]);
    }
  },
  onLoad() {
    // this.coms.allgoods.coms.list.setFixedLsc([{ patternId: 14, pTypeId: 23, operation: 1, val1: this.getOption('itemId') }]);

    request.addOften(this, this.getOption('itemId'));
  }
}]);

Page(getPage(StoreDetailMixin, {
  pageId: 184
}));
