import { formatDate, removeHtml } from '../../utils/utils';
import getPage from '../../module/page';
import { list } from '../../polaris/polaris';
import mixin from '../../utils/mixin';
import regeneratorRuntime from '../../lib/regenerator-runtime/runtime';
import request from '../../config/request';
import viewpage from '../../module/viewpage';

const ViewDataMixin = mixin(viewpage, [{
  customModifyItem(item) {
    item.__c13 = formatDate(item.__c13, 'yyyy年MM月dd日');
    item.__c14 = formatDate(item.__c14, 'yyyy年MM月dd日');
    item.__c19 = removeHtml(item.__c19);
  },
  updateButtons() {
    return [{
      id: 'participate',
      label: '立即参与',
      icon: 'fa fa-check'
    }];
  },
}]);

Page(getPage(ViewDataMixin));
