import commonPage from '../../module/commonPage';
import config from '../../config/config';
import getPage from '../../module/page';
import { list } from '../../polaris/polaris';
import log from '../../utils/log';
import mixin from '../../utils/mixin';
import regeneratorRuntime from '../../lib/regenerator-runtime/runtime';

import { getSubDomain } from '../../utils/request';
import storage from '../../utils/storage';

import { login } from '../../redux/login';

import { loadUser } from '../../redux/user';

import { logout } from '../../redux/login';

//  loadUser(Object.assign({ server_identity: user.UserId, ID: user.UserId, primaryText: user.XingMing }, user))

const SystemMixin = mixin(commonPage, [{
  components: {
    list
  },

  updateRedux({  user }) {



    this.coms.list.setData({
      primaryText: '账号:' + user.XingMing,
      url: user.wx.avatarUrl,
    }, 'items[0].items[0]');
  },
  methods: {    moreButtonClicked(button) {

       const that = this;

        console.log(button);
      if (button.id === 'logout') {
        storage.removeItem('subDomain').then(() => {
               getApp().subDomain  = '';
               storage.removeItem('userData').then(()=>{

                    const extra = { logout :true  };
                    that.redux.loginAction({extra});

                    wx.navigateTo({
                       url:'/pages/auth/index',
                   });




               });

        });
      }


       if (button.id ==='location'){

             wx.stopLocationUpdate();



       }


    },
    payTest() {
       console.log('payTest');
       wx.requestPayment({
         timeStamp:'1501490676',
         nonceStr:'9242F500A8F94878B80F525375B5CDD4',
         package:'prepay_id=wx2017073116443677b2619df10280981505',
         signType:'MD5',
         paySign:'D96C498E4F849BCDBBA08706B896FF28',
         complete: function(){
             console.log('cesss');
         }


       })
    },
    bindgetuserinfo: function (e) {
      var that = this;
      console.log(that);
      if (e.detail.userInfo) {
        // 发送 res.code 到后台换取 openId, sessionKey, unionId
        wx.login({
          success: res => {

               this.redux.loginAction();

            }
        })
      } else {
        wx.showToast({
          title: "为了您更好的体验,请先同意授权",
          icon: 'none',
          duration: 2000
        });
      }
    },
  },
  onLoad() {
    const sections = [];

    sections.push({
      ID: 0,
      type: 'list-auth',
      class: 'b-t m-b-sm',
      items: [
        {
          primaryText: '用户',
          url: '/images/user.png',
          imageClass: 'avatar thumb m-r-sm2',
          primaryClass: 'text-md'
        }
      ]
    });

    sections.push(
      {
        ID: 1,
        type: 'grid',
        itemClass: 'col-xs-4',
        class: 'm-b-sm padder-v bg-white',
        items: [
          {
            label: '我的待办',
            url: '/images/yuyues.png',
            pageId: 510
          },
          {
            label: '业务消息',
            url: '/images/dingdans.png',

          },
          {
            label: '个人档案',
            url: '/images/gouwuches.png',

          }
        ].map((item, index) => Object.assign(item))
      });
    sections.push(
      {
        ID: 3,
        type: 'list-item',
        class: 'm-b-sm',
        items: [
          {
            primaryText: '重置密码',
            url: '/images/huodongs.png',
            pageId: 543

          }
        ].map((item, index) => Object.assign(item))
      });


    sections.push(
      {
        ID: 6,
        type: 'list-item',
        items: [
          {
            primaryText: '使用说明',
            url: '/images/xiaoxis.png',
            pageId: 'note'
          },
          {
            primaryText: '预约联系客服',
            url: '/images/lianxikefus.png',
            pageId: 169
          }
        ].map((item, index) => Object.assign(item))
      });

      sections.push({
             ID: 'submit',
             type: 'button',
               items: [
                 {
                    id:'logout',
                    primaryText: '退出账号',

                 },
                    // {
                    //    id:'location1',
                    //    primaryText: '定位服务',
                    //    pageId :'location'
                    // }
               ]


      });

      console.log(sections);

    this.coms.list.updateItems(sections);

   getSubDomain().then((ret)=>{

       console.log(ret);
   })

  }
}]);

Page(getPage(SystemMixin));
