import Component from '../../components/component';
import mixin from '../../utils/mixin';
import { login } from '../../redux/login';
import config from '../../config/config';
import storage from '../../utils/storage';

export default mixin(Component, [
    {
        reduxState: [   'login', 'user' ],
        data: {
            visible: false,
            wxwork:false,
            authCodeConfig: config.authCode,
            confirmDisabled: config.authCode && config.authCode.required ? true : false,

            server: config.authCode.server,
            domain:'',
            demo:config.authCode.demo && config.authCode.demo.server? true:false
        },
        defaultShowCss() {
            return {
                main: 'zoomIn',
                back: 'fadeIn'
            };
        },
        defaultHideCss() {
            return {
                main: 'zoomOut',
                back: 'fadeIn'
            };
        },
        reduxDispatch: {
            loginAction: login
        },
        updateRedux({ login }) {
            if (this.redux.login !== login && this.loginlogin) {
                if (login.logining) {
                    this.emit('showLoading', this.page);
                } else if (this.loginlogin) {


                      console.log(login);



                    this.loginlogin = false;
                    if (login.error) {
                        let message = '登录失败,请稍后重试';
                        if (login.error.code === 'ECONNABORTED') {
                            message = '请求超时,请检查您的网络环境';
                        } else if (login.error.message) {
                            message = login.error.message;
                        }
                        this.emit('hideLoading', this.page, message + '登录失败,请稍后重试', true);
                    } else {
                        this.emit('hideLoading', this.page);
                        this.setHidden();
                        if (this.params.callback) {
                          //  console.log('this.params.callback');
                          //  this.params.callback();
                            wx.switchTab({ url: '/pages/home/index' });
                        }else{
                        //    console.log('stab');
                            wx.switchTab({ url: '/pages/home/index' });
                        }
                    }
                }
            }
        },
        methods: {
            isLogged2() {
                console.log(this.redux.user);
                return this.redux.user && this.redux.user.UserId && this.redux.user.XingMing !== '匿名';
            },
            authInput(e) {
                this.setData({
                    confirmDisabled: config.authCode.required ? e.detail.value.length === 0 : false,
                    authCode: e.detail.value
                });
            },
            authInput2(e) {
                this.setData({
                    domain : e.detail.value
                });
            },
            handleOutTap(e) {
                return false;
                if (this.getData().onlyFun || this.getData().hasMorePage) {
                    this.setHidden();
                    if (!this.getData().onlyFun) {
                        wx.navigateBack();
                    }
                }
            },
            handleDemo(info) {
                if (info.detail.errMsg === 'getUserInfo:ok' && !this.loginlogin) {
                  this.loginlogin = true;
                  const extra = { ...this.params.extra, authCode: config.authCode.demo.code   };
                   if (config.authCode.demo && config.authCode.demo.server){
                     storage.setItem('subDomain', config.authCode.demo.server).then(() => {
                            getApp().subDomain  = config.authCode.demo.server;
                            console.log('xxx1');
                            this.redux.loginAction({ extra });
                     });
                   }
                 }
            },
            getUserInfo(info) {
                if (info.detail.errMsg === 'getUserInfo:ok' && !this.loginlogin) {
                    this.loginlogin = true;
                    const extra = { ...this.params.extra, authCode: this.getData().authCode  };

                  //   this.redux.loginAction({ extra });

                    storage.setItem('subDomain', this.getData().domain).then(() => {
                           getApp().subDomain  = this.getData().domain;
                           this.redux.loginAction({ extra });
                    });


                }
            },
            getUserInfo2() {

              if (!this.loginlogin) {
                  this.loginlogin = true;


                  const errorTips = () => {
                        this.loginlogin = false;
                        getApp().subDomain  = '';
                        wx.showModal({   title: '提示',    content: "服务器资源已用完，请联系微信客服z18061201672开通，或使用测试账号" ,               });
                  };



                  wx.qy.login({
                     success: function(res) {
                       if (res.code) {
                         console.log(res.code);
                         //发起网络请求
                         wx.request({
                               url:  config.registerUrl   , //仅为示例，并非真实的接口地址
                               data: {  code : res.code   },
                               header: {
                                 'content-type': 'application/json' // 默认值
                               },
                               success (resx) {

                                    if (resx.data.name){
                                        storage.setItem('subDomain', resx.data.name).then(() => {
                                               console.log(resx);
                                               getApp().subDomain  = resx.data.name;
                                               const extra = { ...this.params.extra  };
                                               this.redux.loginAction({ extra });

                                        });
                                    } else {

                                        errorTips();

                                    }

                               }
                             });

                       } else {

                         errorTips();
                       }
                     }
                   });





              }


            },
            handleDemo2() {
                if (!this.loginlogin) {
                  this.loginlogin = true;
                  const extra = { ...this.params.extra, authCode: config.authCode.demo.code   };
                   if (config.authCode.demo && config.authCode.demo.server){
                     storage.setItem('subDomain', config.authCode.demo.server).then(() => {
                            getApp().subDomain  = config.authCode.demo.server;
                            console.log('xxx1');
                            this.redux.loginAction({ extra });
                     });
                   }
                 }
            }
        },
        isLogged() {
            return this.redux.user && this.redux.user.UserId && this.redux.user.XingMing !== '匿名';
        },
        handleShow(scope, params) {

          console.log('actionx');

          wx.getSystemInfo({
              success: (sysInfo) => {






                    const checkPopup = (loginPopUp) => {

                         console.log(loginPopUp);
                         console.log(this);
                         console.log(this.isLogged2());

                      if (this.isLogged2() && !loginPopUp) {
                          if (params && params.callback) {
                              params.callback();
                          }
                      } else {
                          wx.getSetting({
                              success: (res) => {
                                  this.params = params || {};

                                  this.setData({
                                      onlyFun: this.params.onlyFun ? true : false
                                  });

                                  const  that =this;

                                  console.log(res);

                                  if (res.authSetting['scope.userInfo'] && getApp().subDomain   ) {
                                      if (!this.loginlogin) {
                                          this.loginlogin = true;
                                          this.redux.loginAction({ extra: this.params.extra });
                                      }
                                  } else {

                                     if (sysInfo.environment && sysInfo.environment=='wxwork'){
                                        this.setData({wxwork:true});

                                        storage.getItem('userData').then((userData) => {
                                          if ( userData)
                                          {
                                            if (!this.loginlogin) {
                                                this.loginlogin = true;
                                                this.redux.loginAction({ extra: this.params.extra });
                                            }
                                          }
                                          else {
                                            this.setVisible();
                                          }
                                        }).catch(function(){ that.setVisible(); });


                                     }
                                     else{
                                       this.setVisible();
                                     }





                                  }
                              }
                          });
                      }


                    };



                    storage.getItem('subDomain').then((d) => {
                          let loginPopUp = true;
                          if (d) {
                              getApp().subDomain =  d;
                              loginPopUp=false;
                          } else {

                          }
                          console.log('ddx');
                          checkPopup(loginPopUp);


                     }).catch(
                        function(){
                           console.log('eeer');
                           checkPopup(true);
                        }

                     );









                    //}


                  }

             });



        },
        onLoad() {

            this.on('showAuth', this.handleShow);
            this.setData({
                hasMorePage: getCurrentPages().length > 1
            });
        }
    }
]);
