import Component from '../../components/component';
import mixin from '../../utils/mixin';
import request from '../../config/request';
import switchVisibleByTouchDirectionMixin from '../../module/switchVisibleByTouchDirectionMixin';

export default mixin(Component, [
    {
        data: {
            visible: false,
            comment: '',
            images: []
        },
        defaultShowCss: 'fadeInUp',
        defaultHideCss: 'fadeOutDown',
        onLoad() {
            this.on('showComment', this.showComment);
        },
        showComment(scope) {
            this.setVisible();
        },
        methods: {
            handleAttachment(e) {
                wx.chooseImage({
                    count: this.getData().attachment === 'attachment' ? 1 : 9,
                    success: (data) => {
                        const images = this.getData().images.concat(data.tempFilePaths);
                        this.setData({ images });
                    }
                });
            },
            handleRemoveAttachment(e) {
                const findex = e.currentTarget.dataset.findex;
                const images = this.getData().images;
                this.setData({
                    images: images.slice(0, findex).concat(images.slice(findex + 1))
                });
            },
            handleHideComment(e) {
                this.setHidden();
            },
            handleUpdateComment(e) {
                setTimeout(() => {
                    const data = this.getData();
                    if (data.comment) {
                        this.sendComment && this.sendComment(data.comment, data.images);

                        this.setData({
                            comment: '',
                            images: []
                        });
                        this.setHidden();
                    }
                }, 20);
            },
            handleComment(e) {
                // console.log(e.detail);
                this.setData({
                    comment: e.detail.value
                });
            }
        }
    }
]);
