import Component from '../../components/component';
import mixin from '../../utils/mixin';
import request from '../../config/request';
import switchVisibleByTouchDirectionMixin from '../../module/switchVisibleByTouchDirectionMixin';

export default mixin(Component, [
    {
        data: {
            visible: false,
            comment: '',
            score: '',
            wstat: false,
            wstats:[{key:'合格',value:40015},{key:'待整改',value:40016},{key:'已整改',value:40017},
          {key:'已验收',value:40018},{key:'打回',value:40019}],
            images: []
        },
        defaultShowCss: 'fadeInUp',
        defaultHideCss: 'fadeOutDown',
        onLoad() {
            this.on('showComment', this.showComment);
        },
        showComment(scope) {
            this.setVisible();
        },

        methods: {
            bindPickerChange(e) {
               console.log('picker发送选择改变，携带值为', e.detail.value)
               this.setData({
                 index: e.detail.value
               })
            },

            handleAttachment(e) {
                wx.chooseImage({
                    count: this.getData().attachment === 'attachment' ? 1 : 9,
                    success: (data) => {
                        const images = this.getData().images.concat(data.tempFilePaths);
                        this.setData({ images });
                    }
                });
            },
            handleRemoveAttachment(e) {
                const findex = e.currentTarget.dataset.findex;
                const images = this.getData().images;
                this.setData({
                    images: images.slice(0, findex).concat(images.slice(findex + 1))
                });
            },
            handleHideComment(e) {
                this.setHidden();
            },
            handleUpdateComment(e) {
                setTimeout(() => {
                    const data = this.getData();
                    if (data.comment) {
                        this.sendComment && this.sendComment(data.comment, data.images,data);

                        this.setData({
                            comment: '',
                            images: [],
                            score: '',
                            wstat: false
                        });
                        this.setHidden();
                    }
                }, 20);
            },

            handleScore(e) {
                // console.log(e.detail);
                this.setData({
                    score: e.detail.value
                });
            }
            ,
            handleStat(e) {
                 console.log(e.detail);
                this.setData({
                    wstat: e.detail.value
                });
            },
            handleComment(e) {
                // console.log(e.detail);
                this.setData({
                    comment: e.detail.value
                });
            }
        }
    }
]);
