import filterMixin from '../../module/filterMixin';
import filterpanelMixin from '../../module/filtpanelMixin';
import list from '../list/list';
import log from '../../utils/log';
import mixin from '../../utils/mixin';
import panelpicker from '../panelpicker/panelpicker';
import { updateSort } from '../../redux/filter';

export default mixin(panelpicker, [filterMixin, filterpanelMixin,
  {
    position: 'right',
    components: {
      list: {
        component: list,
        options(owner) {
          return {
            data: {
              itemType: 'list-item'
            },
            deselectable: true,
            pageId: -1,
            customDataChanged: owner.customDataChanged.bind(owner)
          };
        }
      }
    },
    filtManager(scope, item) {
      // console.log(scope,item);
      this.orgListData = null;
      this.returnScope = scope;
      this.redux.initFilter({ pageId: this.getOption('pageId'), selected: this.getOption('selected') });
      this.index = this.filter.filtable.findIndex(f => f.ID === item.ID);
      this.type = item.type;
      this.initSelect = true;
      this.setData({
        type: item.type
      });
      this.show();
      this.checkItem();
    },
    onLoad(options) {
      this.on('filtManager', this.filtManager);
      this.on('hideFiltManager', this.hide);
    },
    showPanelPicker(scope, checkType, items) {

    }
  }
]);
