import filterMixin from '../../module/filterMixin';
import filterpanelMixin from '../../module/filtpanelMixin';
import list from '../list/list';
import log from '../../utils/log';
import mixin from '../../utils/mixin';
import panel from '../panel';
import immutable from '../../lib/seamless-immutable/src/seamless-immutable';
const regeneratorRuntime = require('../../lib/regenerator-runtime/runtime');
import unionBy from '../../lib/lodash/unionBy';
import { getStatusMap } from '../../utils/utils';

export default mixin(panel, [filterMixin, filterpanelMixin,
  {
    position: 'right',
    level: {},
    components: {
      list: {
        component: list,
        options(owner) {
          return {
            data: {
              itemType: 'list-item'
            },
            deselectable: true,
            pageId: -1,
            customDataChanged: owner.customDataChanged.bind(owner)
          };
        }
      }
    },
    filtManager(scope, item) {
      this.setHidden('', ()=>{
        this.setData({
          returnScope: scope,
          searchInput: '',
          alpha: false
        });
        this.type = item.type;
        this.setData({
          type: item.type
        });
        // if (this.props.anchor) {
        //   this.changePosition('top');
        // } else {
        //   this.changePosition('right');
        // }

        if (this.getOption('pageId') != this.oldPageId) {
          this.level = {};
          this.levelParents = {};
          this.history = {};
          this.oldPageId = this.getOption('pageId');
        }
        this.initSelect = true;
        this.tabFilter = item.tabFilter;
        this.ID = item.ID;
        this.orgListData = null;
        this.redux.initFilter({ pageId: this.getOption('pageId'), selected: this.getOption('selected') });
        this.show();
        this.checkItem();
      });
    },
    clearFilter(filtable) {
      if (filtable.linkChain) {
        filtable.linkChain.forEach(l => {
          this.redux.updateSingleFilter({ pageId: this.getOption('pageId'), items: [], columnID: l.ID });
        });
      } else {
        this.redux.updateSingleFilter({ pageId: this.getOption('pageId'), items: [], columnID: filtable.ID });
      }
      this.checkItem();
    },
    handleButtonEvent(scope, button, item, gindex, index) {
      if (button  === 'clear') {
        const filtable = this.filter.filtable[this.index];
        this.clearFilter(filtable);
      } else if (button && button.id === 'upLevel') {
        this.level[button.filtableID] --;
        this.checkItem();
      }
    },
    onLoad() {
      this.on('checkable-tap', this.checkableTap);
      this.on('filtManager', this.filtManager);
      this.on('hideFiltManager', this.hide);
      this.on('buttonClick', this.handleButtonEvent);
    },
    methods: {
      handleConfirm() {
        this.hide();
        this.emit('panelPickerReturn', this.page, this.getData().returnScope, this.getData().key, this.selected);
      }
    },
    panelPickerReturn(scope, returnScope, key, selected) {
      if (scope === this.scope) {
        this.redux.confirmFilter({ pageId: this.getOption('pageId') });
      } else if (returnScope === this.scope) {
        this.show();

        key && this.redux.updateSingleFilter({ pageId: this.getOption('pageId'), items: selected, columnID: key.column.ID });
      }
    },
    setSingleList(ii) {
      if (ii >= this.filter.filtable.length) {
        return {
          items: []
        };
      }
      let filtable = this.filter.filtable[ii];

      filtable = this.getLevel(filtable);

      const checkType = filtable.multi ? 'check' : 'radio';
      const filt = this.getFilterValue(filtable);
      const first = filt && filt.length > 0 && filt[0];
      const min = first && first.min || '';
      const max = first && first.max || '';
      const eid = `__c${filtable.ID}`;
      const filtableID = filtable.ID;

      if (filtable.pTypeId === 24) {
        if (first || this.location) {
          return {
            checkType,
            items: [{ tag: filtable.primaryText,
              items: [first || this.location],
              pTypeId: filtable.pTypeId,
              key: ii,
              type: 'list-item'
            }]
          };
        } else {
          wx.getLocation({
            type: 'gcj02', //返回可以用于wx.openLocation的经纬度//
            success: (res) => {
              this.location = { primaryText: '我的位置', min: res.longitude, max: res.latitude, eid, filtableID };
              this.checkItem();
            },
            fail(error) {
              log(error);
            }
          });
          return {
            checkType: '',
            items: [{
              tag: filtable.primaryText,
              items: [{ primaryText: '正在定位...',
                type: 'list-item',
                noNav: true
              }]
            }]
          };
        }
      } else {
        const  statusMap = getStatusMap(filtable, {
          users: this.redux.cuser.data, departments: this.redux.department.data, statusMap: this.filter.statusMap
        });
        let items = (filtable.filter ? statusMap.filter(filtable.filter) : statusMap) || [];

        if (this.levelParents[filtable.ID]) {
          items = items.filter(i => i.parentId === this.levelParents[filtable.ID]);
        }

        let itemProp = { columnCount: 4 };

        items = items.map(i => Object.assign({ eid, filtableID, useCheckIcon: true, checkIconClass: 'text-lg text-primary font-thin', uncheckIconClass: 'text-lg text-muted font-thin', checked: filt.find(f => f.ID === i.ID) }, i, itemProp));



        items = immutable([{
          type: 'tag-label',
          primaryText: '全部',
          columnCount: 4,
          eid,
          filtableID,
          checked: filt.find(f => typeof f.ID === 'undefined')
        }]).concat(items);

        console.log(items);

        if (filtable.pTypeId == 4) {
          /// 数值
          items = immutable([{
            columns: [
              {
                noLabel: true,
                editType: 'number-range',
                eid,
                filtableID,
                ID: filtable.ID,
                property: {}
              }
            ],
            uncheckable: true,
            columnCount: 1,
            [`__c${filtable.ID}`]: { min, max }
          }]).concat(items);
        } else if (filtable.pTypeId == 6) {
          /// 日期
          items = immutable([{
            columns: [
              {
                noLabel: true,
                editType: 'date-range',
                eid,
                filtableID,
                ID: filtable.ID,
                property: {},
              }
            ],
            uncheckable: true,
            columnCount: 1,
            [`__c${filtable.ID}`]: { min, max }
          }]).concat(items);
        } else if (filtable.pTypeId == 5 || filtable.pTypeId == 7) {
          /// 字符串
          items = immutable([{
            columns: [
              {
                noLabel: true,
                editType: 'filttext',
                eid,
                filtableID,
                ID: filtable.ID,
                property: {},
              }
            ],
            uncheckable: true,
            columnCount: 1,
            [`__c${filtable.ID}`]: { min }
          }]).concat(items);
        }



        return {
          checkType,
          items: [{ tag: filtable.primaryText,
            items,
            pTypeId: filtable.pTypeId,
            key: ii
          }]
        };
      }
    },
    getLevel(filtable) {
      let temp = filtable;
      let level = this.level[filtable.ID];
      while(level && temp && temp.child) {
        temp = temp.child;
        level --;
      }
      return temp;
    },
    getFilterValue(filtable) {
      return (this.filter.filter && this.filter.filter[filtable.ID]) || [];
    },
    itemTaped(items, indexs, item) {
      const eid = this.coms.list.getData().items[indexs[0]].items[indexs[1]].eid;
      const index = this.filter.filtable.findIndex(c => c.eid === eid || (c.linkChain && c.linkChain.find(l => l.eid === eid)));
      const filtable = this.filter.filtable[index];
      let levelFiltable = this.getLevel(filtable);

      // 单选历史
      if (item.history) {
        if (filtable.linkChain) {
          filtable.linkChain.forEach(l => {
            this.redux.updateSingleFilter({ pageId: this.getOption('pageId'), items: [], columnID: l.ID });
          });
          this.level[filtable.ID] = filtable.linkChain.findIndex(l => l.ID === item.levelFiltableID);
        }
        this.redux.updateSingleFilter({ pageId: this.getOption('pageId'), items: [item], columnID: item.levelFiltableID });
        this.history[filtable.ID] = [item].concat(this.history[filtable.ID].filter(i => i.ID !== item.ID));

        this.handleConfirm();
        return;
      }

      // 多选已选
      if (item.selected) {
        const filter = this.getFilterValue({ ID: item.levelFiltableID });
        this.redux.updateSingleFilter({ pageId: this.getOption('pageId'), items: filter.filter(f => f.ID !== item.ID), columnID: item.levelFiltableID });
        return;
      }

      items = this.dealWithAll(items, indexs);
      /// 多级数据
      if (filtable.linkChain) {
        /// 点击的不是全部，而且当前level有子节点
        if (item.ID && levelFiltable.child) {
          const  statusMap = getStatusMap(levelFiltable.child, {
            users: this.redux.cuser.data, departments: this.redux.department.data, statusMap: this.filter.statusMap
          });
          if (statusMap.filter(s => s.parentId === item.ID).length > 0) {
            this.level[filtable.ID] = (this.level[filtable.ID] || 0) + 1;
            this.levelParents[levelFiltable.child.ID] = item.ID;
            this.checkItem();
            return;
          }
        }

        let mostTop = false;
        if (!item.ID) {
          /// 点击全部
          if (levelFiltable.ancestor) {
            const parent = filtable.linkChain.find(ll => ll.ID === levelFiltable.ancestor );
            /// 选择上一级
            const  statusMap = getStatusMap(parent, {
              users: this.redux.cuser.data, departments: this.redux.department.data, statusMap: this.filter.statusMap
            });
            items = statusMap.filter(s => s.ID === this.levelParents[levelFiltable.ID]);
            item = items[0];
            levelFiltable = parent;
          } else {
            mostTop = true;
          }
        }

        if (mostTop) {
          this.clearFilter(filtable);
        } else {
          if (filtable.multi) {
            /// 获取本级
            const filter = this.getFilterValue(levelFiltable);
            items = unionBy(items, filter, 'ID');
            /// 清除本级以下的
            let tempItems = [item];
            let temp = levelFiltable.child;
            while(temp) {
              const  statusMap = getStatusMap(temp, {
                users: this.redux.cuser.data, departments: this.redux.department.data, statusMap: this.filter.statusMap
              });
              const children = statusMap.filter(s => tempItems.find(t => t.ID === s.parentId));
              const filter = this.getFilterValue(temp);
              this.redux.updateSingleFilter({ pageId: this.getOption('pageId'), items: filter.filter(s => !children.find(c => c.ID === s.ID)), columnID: temp.ID });
              tempItems = children;
              temp = temp.child;
            }
            /// 清除本级以上的
            let tempItem = item;
            if (levelFiltable.ancestor) {
              temp = filtable.linkChain.find(ll => ll.ID === levelFiltable.ancestor );
            }
            while(temp) {
              const  statusMap = getStatusMap(temp, {
                users: this.redux.cuser.data, departments: this.redux.department.data, statusMap: this.filter.statusMap
              });
              const parItem = statusMap.find(s => s.ID === tempItem.parentId);
              const filter = this.getFilterValue(temp);
              this.redux.updateSingleFilter({ pageId: this.getOption('pageId'), items: filter.filter(s => s.ID !== parItem.ID), columnID: temp.ID });
              tempItem = parItem;
              if (temp.ancestor) {
                temp = filtable.linkChain.find(ll => ll.ID === temp.ancestor );
              } else {
                temp = null;
              }
            }
          } else {
            /// 清除所有
            this.clearFilter(filtable);
          }
        }
      }

      if (!filtable.multi) {
        this.history[filtable.ID] = unionBy(items.map(i => Object.assign({ history: true, filtableID: filtable.ID, levelFiltableID: levelFiltable.ID }, i)), this.history[filtable.ID], 'ID').slice(0, 4);
      }
      this.redux.updateSingleFilter({ pageId: this.getOption('pageId'), items, columnID: levelFiltable.ID });
      if (this.coms.list.checkType === 'radio') {
        this.handleConfirm();
      }
    },
    checkableTap(scope, items, indexs, item) {
      const childScope = this.getChildEventScope(scope);
      if (childScope === 'list' && this.type !== 'more2' && this.type !== 'sort'){
        this.itemTaped(items, indexs, item);
      }
    },
    checkItem() {




      if (this.visible && this.filter.filtable) {
        // 查找所有联动关联的最末结点
        const linkColumns = this.orgFilter.filtable.filter(f => f.statusGroup && f.statusGroup.depth > 0 && !this.orgFilter.filtable.find(c => c.statusGroup && c.statusGroup.depth == f.ID));
        let unneed = [].concat(this.tabFilter);

        // 生成联动关联的链
        const linkChain = [];
        linkColumns.forEach(l => {
          const ll = [l];
          let ss = l;
          const find = f => f.ID === ss.statusGroup.depth;
          while (ss && ss.statusGroup.depth) {
            ss = this.orgFilter.filtable.find(find);
            if (ss) {
              ll.unshift(ss);
            }
          }
          const parent = Object.assign({ linkChain: ll }, ll[0]);
          let tp = parent;
          for(let ii = 1; ii < ll.length; ii++) {
            tp.child = Object.assign({ ancestor: tp.ID }, ll[ii]);
            tp = tp.child;
          }
          linkChain.push(parent);
        });

        if (this.type === 'more') {
          for(let ii = 0; ii < linkChain.length; ii++) {
            const lc = linkChain[ii];
            for (let jj = 0; jj < lc.linkChain.length; jj ++) {
              const l = lc.linkChain[jj];
              if (unneed.find(f => f.ID === l.ID)) {
                // unneed中找到联动项，忽略整个联动链
                unneed = unneed.concat(lc.linkChain);
                break;
              }
            }
          }
          this.filter = Object.assign({}, this.orgFilter, { filtable: this.orgFilter.filtable.filter(f => (f.editType === 'status' || f.editType === 'mstatus') &&  !unneed.find(t => t.ID === f.ID)) });
        } else {
          this.filter = Object.assign({}, this.orgFilter, { filtable: this.orgFilter.filtable.filter(f => (f.editType === 'status' || f.editType === 'mstatus')) });;
        }
        // 需要展示的联动项，只显示根结点
        const needLink = [];
        let need = [];
        for(let ii = 0; ii < linkChain.length; ii++) {
          const lc = linkChain[ii];
          for (let jj = 0; jj < lc.linkChain.length; jj ++) {
            const l = lc.linkChain[jj];
            if (this.filter.filtable.find(f => f.ID === l.ID)) {
              need = need.concat(lc.linkChain);
              needLink.push(lc);
              break;
            }
          }
        }
        this.filter = Object.assign({}, this.filter, { filtable: needLink.concat(this.filter.filtable.filter(f => !need.find(t => t.ID === f.ID))) });
        // this.clog(linkColumns, this.orgFilter.filtable);
        if (this.type === 'filter' || this.type === 'extra') {
          if (this.initSelect) {
            this.initSelect = false;
            this.index = this.filter.filtable.findIndex(f => f.ID === this.ID || (f.linkChain && f.linkChain.find(l => l.ID === this.ID)));
          }
          const single = this.setSingleList(this.index);
          const filtable = this.filter.filtable[this.index];

          let items = single.items[0].items.map(i => Object.assign({}, i, { classChecked: 'b b-ecstasy', primaryCheckedClass: 'text-primary' }));

          const gitems = [];

          const checkType = filtable.multi || (filtable.linkChain && filtable.linkChain.find(l => l.multi)) ? 'check' : 'radio';

          if (checkType === 'check') {
            let selected = [];
            if (filtable.linkChain) {
              filtable.linkChain.forEach(l => {
                const filt = this.getFilterValue(l).map(i => Object.assign({ classChecked: 'b b-ecstasy', primaryCheckedClass: 'text-primary', checked: true, selected: true, filtableID: filtable.ID, levelFiltableID: l.ID }, i));
                selected = filt.concat(selected);
              });
            } else {
              const filt = this.getFilterValue(filtable).map(i => Object.assign({ classChecked: 'b b-ecstasy', primaryCheckedClass: 'text-primary', checked: true, selected: true, filtableID: filtable.ID, levelFiltableID: filtable.ID }, i));
              selected = filt;
            }

            gitems.push({
              class: 'm-b-sm',
              header: {
                type: 'header2',
                class: 'padder padder-v-sm bg-white',
                title: `已选`,
                subTitle: selected.length > 0 ? '清空' : '',
                subClass: 'text-primary text-sm',
                subButton: selected.length > 0 ? 'clear' : ''
              },
              type: 'tag-label',
              columnCount: 4,
              items: selected
            });
          } else {
            gitems.push({
              class: 'm-b-sm',
              header: {
                type: 'header2',
                class: 'padder padder-v-sm bg-white',
                title: `历史`
              },
              type: 'tag-label',
              columnCount: 4,
              items: (this.history[filtable.ID] || []).map((h, index) => Object.assign({}, h, { classChecked: 'b b-ecstasy', primaryCheckedClass: 'text-primary', checked: index === 0 }))
            });
          }

          gitems.push({
            header: {
              type: 'header2',
              class: 'padder padder-v-sm bg-white',
              title: `选择:`,
              subTitle: this.level[filtable.ID] > 0 ? '返回上一级' : '',
              subClass: 'text-primary text-sm',
              subButton: this.level[filtable.ID] > 0 ? { id: 'upLevel', filtableID: filtable.ID } : ''
            },
            type: 'tag-label',
            columnCount: 4,
            class: 'b-t',
            items
          });

          this.setData({
            checkType
          });
          this.coms.list.setCheckType(checkType);
          this.coms.list.alpha = false;
          this.coms.list.updateItems(gitems);
        } else if (this.type === 'sort') {
          this.setData({
            checkType: 'radio'
          });
          this.coms.list.setCheckType('radio');
          this.coms.list.alpha = false;
          this.coms.list.updateItems([
              {
                type: 'list-item',
                class: 'b-t',
                items: this.filter.sortable.filter(item => !item.tab)
              }
            ]);
        } else if (this.type === 'more') {
          const gitems = [];
          for (let ii = 0; ii < this.filter.filtable.length; ii += 1) {
            const filtable = this.filter.filtable[ii];
            const single = this.setSingleList(ii);

            let item;
            if (filtable.pTypeId === 1) {
              item = Object.assign({}, filtable, single.items[0], { items: [{
                columns: [
                  {
                    noLabel: true,
                    editType: 'filter-switch',
                    eid: `__c${filtable.ID}`,
                    ID: filtable.ID,
                    property: {},
                    primaryText: filtable.primaryText
                  }
                ],
                uncheckable: true,
                columnCount: 1,
                [`__c${filtable.ID}`]: single.items[0].items[0].checked
              }] });
            } else {
              const items = single.items[0].items.map(i => Object.assign({}, i, { classChecked: 'b b-ecstasy', primaryCheckedClass: 'text-primary' }));

              item = Object.assign({ checkType: single.checkType, header: {
                type: 'header2',
                class: 'padder padder-v-sm bg-white',
                title: `${single.items[0].tag} ${ filtable.multi ? '(可多选)': '' }`,
                subTitle: this.level[filtable.ID] > 0 ? '返回上一级' : '',
                subClass: 'text-primary text-sm',
                subButton: this.level[filtable.ID] > 0 ? { id: 'upLevel', filtableID: filtable.ID } : ''
              }}, filtable, single.items[0], { items });
            }
            if (!item.type) {
              item.type = 'tag-label';
            }
            gitems.push(item);
          }

          this.coms.list.setCheckType('check');
          this.coms.list.alpha = false;
          this.coms.list.updateItems(gitems);
        }
      }
    }
  }
]);
