import filterMixin from '../../module/filterMixin';
import list from '../list/list';
import log from '../../utils/log';
import mixin from '../../utils/mixin';
import panel from '../panel';
import immutable from '../../lib/seamless-immutable/src/seamless-immutable';
const regeneratorRuntime = require('../../lib/regenerator-runtime/runtime');
import unionBy from '../../lib/lodash/unionBy';
import { confirmFilter, updateFilter, updateSort } from '../../redux/filter';
import { getStatusMapChecked, getStatusMap } from '../../utils/utils';
import uniq from '../../lib/lodash/uniq';

export default mixin(panel, [filterMixin,
  {
    position: 'top',
    level: {},
    index: 0,
    data: {
      currentIndex: -1
    },
    filter: {},
    type: 'filter',
    reduxState: ['cuser', 'department'],
    reduxDispatch: { confirmFilter, updateFilter, updateSort },
    filted: {},
    isPanel: true,
    components: {
      list: {
        component: list,
        options(owner) {
          return {
            data: {
              itemType: 'list-item'
            },
            pageId: -1
          };
        }
      },
      list0: {
        component: list,
        options(owner) {
          return {
            data: {
              itemType: 'list-item'
            },
            pageId: -1
          };
        }
      },
      list1: {
        component: list,
        options(owner) {
          return {
            data: {
              itemType: 'list-item'
            },
            pageId: -1
          };
        }
      },
      list2: {
        component: list,
        options(owner) {
          return {
            data: {
              itemType: 'list-item'
            },
            pageId: -1
          };
        }
      },
    },
    filtManager(scope, item) {
      this.setHidden('', () => {
        this.setData({
          returnScope: scope,
          searchInput: '',
          alpha: false
        });
        this.type = item.type;
        this.setData({
          type: item.type
        });
        if (this.getOption('pageId') != this.oldPageId) {
          this.level = {};
          this.levelParents = {};
          this.history = {};
          this.oldPageId = this.getOption('pageId');
        }
        this.initSelect = true;
        this.sortable = item.sortable;
        this.filtable = item.filtable;
        if (this.type === 'more2') {
          this.filtable = item.filtable.map(f => {
            console.log(f);
            const ll = [Object.assign({}, f)];
            if (f.statusGroup && f.statusGroup.depth === 0) {
              let ss = f;
              while (ss) {
                const ch = this.orgFilter.filtable.find(ff => ff.statusGroup.depth === ss.ID);
                if (ch) {
                  ll.push(Object.assign({ parentId: ss.ID }, ch));
                }
                ss = ch
              }
            }
            return Object.assign({}, f, { link: ll })
          })
        }
        this.filted = this.orgFilter.filter || immutable({})
        this.listIndex = 0;
        this.indexes = null;
        this.show();
        this.checkItem();
      });
    },
    checkableTap(scope, items, indexs, item) {
      const childScope = this.getChildEventScope(scope);
      if (this.type === 'sort') {
        this.redux.updateSort({ pageId: this.getOption('pageId'), items });
        this.redux.confirmFilter({ pageId: this.getOption('pageId') });
        this.isPanel && this.hide();
      } else if (this.type === 'more') {
        const eid = item.eid;
        const column = this.filter.filtable.find(c => c.eid === eid);
        this.filted = this.filted.merge({ [column.ID]: this.dealWithAll(items, indexs) })
        this.checkItem()
        this.isPanel === false && this.redux.confirmFilter({ pageId: this.getOption('pageId') });
      } else {
        if (childScope === 'list') {
          this.listIndex = indexs[1]
          this.indexes = null
          this.checkItem()
        } else {
          const listCount = this.filtable[this.listIndex].link.length
          if (`list${listCount - 1}` === childScope) {
            this.itemTaped(items, indexs, item);
          } else {
            this.indexes[childScope.substring(4)] = indexs[1]
            this.checkItem()
          }
        }
        // this.filted = this.filted.merge({ [this.filter.filtable[this.getData().currentIndex].ID]: this.dealWithAll(items, indexs) })
        // this.checkItem()
      }
    },
    clearFilter(filtable) {
      if (filtable.linkChain) {
        filtable.linkChain.forEach(l => {
          this.filted = this.filted.merge({ [l.ID]: [] })
        });
      } else {
        this.filted = this.filted.merge({ [filtable.ID]: [] })
      }
      this.checkItem();
    },
    handleButtonEvent(scope, button, item, gindex, index) {
      if (button === 'clear') {
        const filtable = this.filter.filtable[this.index];
        this.clearFilter(filtable);
      } else if (button && button.id === 'upLevel') {
        this.level[button.filtableID]--;
        this.checkItem();
      }
    },
    onLoad() {
      this.on('checkable-tap', this.checkableTap);
      this.on('filtManager', this.filtManager);
      this.on('hideFiltManager', this.hide);
      this.on('buttonClick', this.handleButtonEvent);
    },
    methods: {
      handleConfirm() {
        this.hide();
        if (this.type !== 'sort') {
          this.redux.updateFilter({ pageId: this.getOption('pageId'), filter: this.filted })
        }
        this.redux.confirmFilter({ pageId: this.getOption('pageId') });
      },
      handleReset(e) {
        this.filtable.forEach(f => {
          if (f.link){

            f.link.forEach(l => {
              this.filted = this.filted.without(l.ID)
            })

          }

        })
      }
    },
    updateRedux(props) {
      const { filter } = props;
      const theFilter = filter[this.getOption('pageId')];
      if (theFilter && theFilter !== this.orgFilter) {
        this.orgFilter = theFilter;
        this.filter = this.filtFilter && theFilter.filtable ? this.filtFilter(theFilter) : theFilter;
      }
    },
    dealWithAll(items, indexs) {
      // 当前点击区域的数据
      items = items.filter(i => i.indexes[0] === indexs[0]);
      if (items.length > 1) {
        // 包含全部项
        const all = items.find(i => typeof i.ID === 'undefined');
        if (all) {
          // 点击的就是全部项
          if (all.indexes[0] === indexs[0] && all.indexes[1] === indexs[1]) {
            items = [all];
          } else if (items.find(i => i.indexes[1] === indexs[1])) {
            items = items.filter(i => typeof i.ID !== 'undefined');
          }
        }
      }
      return items;
    },
    setSingleList(filtable, parentId, isLast, selectedRow, otherProps) {
      const checkType = filtable.multi && isLast ? 'check' : 'radio';
      const filt = this.getFilterValue(filtable);
      const first = filt && filt.length > 0 && filt[0];
      const min = first && first.min || '';
      const max = first && first.max || '';
      const eid = `__c${filtable.ID}`;
      const filtableID = filtable.ID;

      if (filtable.pTypeId === 24) {
        if (first || this.location) {
          return {
            checkType,
            items: [{
              tag: filtable.primaryText,
              items: [first || this.location],
              pTypeId: filtable.pTypeId,
              key: filtable.ID,
              type: 'list-item'
            }]
          };
        } else {
          wx.getLocation({
            type: 'gcj02', //返回可以用于wx.openLocation的经纬度//
            success: (res) => {
              this.location = { primaryText: '我的位置', min: res.longitude, max: res.latitude, eid, filtableID };
              this.checkItem();
            },
            fail(error) {
              log(error);
            }
          });
          return {
            checkType: '',
            items: [{
              tag: filtable.primaryText,
              items: [{
                primaryText: '正在定位...',
                type: 'list-item',
                noNav: true
              }]
            }]
          };
        }
      } else {
        const statusMap = getStatusMap(filtable, {
          users: this.redux.cuser.data, departments: this.redux.department.data, statusMap: this.filter.statusMap
        });
        let items = (filtable.filter ? statusMap.filter(filtable.filter) : statusMap) || [];

        if (parentId) {
          items = items.filter(i => i.parentId === parentId);
        }

        items = items.map((i, index) => {
          const checked = filt.find(f => f.ID === i.ID)
          return Object.assign({ eid, filtableID, checked: isLast ? checked : index === selectedRow, selected: isLast ? false : checked }, i, otherProps);
        });

        isLast &&
          (items = immutable([{
            primaryText: '不限',
            eid,
            filtableID,
            parentId,
            checked: filt.find(f => typeof f.ID === 'undefined'),
            ...otherProps
          }]).concat(items));

        return {
          checkType,
          items: [{
            tag: filtable.primaryText,
            items,
            pTypeId: filtable.pTypeId,
            key: filtable.ID
          }]
        };
      }
    },
    getLevel(filtable) {
      let temp = filtable;
      let level = this.level[filtable.ID];
      while (level && temp && temp.child) {
        temp = temp.child;
        level--;
      }
      return temp;
    },
    getFilterValue(filtable) {
      return this.filted[filtable.ID] || [];
    },
    itemTaped(items, indexs, item) {
      const columns = this.filtable[this.listIndex].link;
      let childColumn = columns[columns.length - 1]
      const parentId = item.parentId
      const isMulti = childColumn.multi
      let children = this.filted[childColumn.ID] || []
      if (isMulti && parentId) {
        if (indexs[1] === 0 && item.checked) {
          this.filted = this.filted.merge({ [childColumn.ID]: [item].concat(children.filter(c => c.parentId !== parentId)) })
          items = []
        } else {
          items = items.filter(i => i.ID)
          this.filted = this.filted.merge({ [childColumn.ID]: items.concat(children.filter(c => c.parentId !== parentId)) })
        }

        children = items
        for (let ii = columns.length - 2; ii >= 0; ii--) {
          const parentColumn = columns[ii]
          const curParItem = this.coms[`list${ii}`].getData().items[0].items[this.indexes[ii]]
          let parentFiltedItems = this.filted[parentColumn.ID] || []
          let otherFiltedItems = []
          if (curParItem.parentId) {
            otherFiltedItems = parentFiltedItems.filter(f => f.parentId !== curParItem.parentId)
            parentFiltedItems = parentFiltedItems.filter(f => f.parentId === curParItem.parentId)
          }
          const found = parentFiltedItems.findIndex(f => f.ID === curParItem.ID)
          // 有子节点，并且没找到父节点
          if (children.length && found === -1) {
            parentFiltedItems = parentFiltedItems.concat([curParItem])
            this.filted = this.filted.merge({ [parentColumn.ID]: parentFiltedItems.concat(otherFiltedItems) })
          } else if (children.length === 0 && found >= 0) {
            parentFiltedItems = parentFiltedItems.slice(0, found).concat(parentFiltedItems.slice(found + 1))
            this.filted = this.filted.merge({ [parentColumn.ID]: parentFiltedItems.concat(otherFiltedItems) })
          } else {
            break;
          }

          children = parentFiltedItems
        }
      } else {
        if (indexs[1] === 0 && item.checked) {
          this.filted = this.filted.merge({ [childColumn.ID]: [item] })
          items = []
        } else {
          items = items.filter(i => i.ID)
          this.filted = this.filted.merge({ [childColumn.ID]: items })
        }
        // console.log('第一层 或者 单选', items)
        if (!isMulti) {
          children = items
          for (let ii = columns.length - 2; ii >= 0; ii--) {
            const parentColumn = columns[ii]
            const curParItem = this.coms[`list${ii}`].getData().items[0].items[this.indexes[ii]]
            let parentFiltedItems = this.filted[parentColumn.ID] || []
            const found = parentFiltedItems.length && parentFiltedItems[0].ID === curParItem.ID
            // 有子节点，并且没找到父节点
            if (children.length && !found) {
              parentFiltedItems = [curParItem]
              this.filted = this.filted.merge({ [parentColumn.ID]: parentFiltedItems })
            } else if (children.length === 0 && parentFiltedItems.length > 0) {
              parentFiltedItems = []
              this.filted = this.filted.merge({ [parentColumn.ID]: parentFiltedItems })
            } else {
              break;
            }

            children = parentFiltedItems
          }
        }
      }

      // console.log(this.filted)
      // children = this.filted[childColumn.ID]
      // for (let ii = columns.length - 2; ii >= 0; ii--) {
      //   const parentColumn = columns[ii]
      //   const curParItem = this.coms[`list${ii}`].getData().items[0].items[this.indexes[ii]]

      //   childColumn = parentColumn
      //   children = this.filted[childColumn.ID]
      // }

      this.checkItem()
      // const eid = this.coms.list.getData().items[indexs[0]].items[indexs[1]].eid;
      // const index = this.filter.filtable.findIndex(c => c.eid === eid || (c.linkChain && c.linkChain.find(l => l.eid === eid)));
      // const filtable = this.filter.filtable[index];
      // let levelFiltable = this.getLevel(filtable);

      // items = this.dealWithAll(items, indexs);
      // /// 多级数据
      // if (filtable.linkChain) {
      //   /// 点击的不是不限，而且当前level有子节点
      //   if (item.ID && levelFiltable.child) {
      //     const statusMap = getStatusMap(levelFiltable.child, {
      //       users: this.redux.cuser.data, departments: this.redux.department.data, statusMap: this.filter.statusMap
      //     });
      //     if (statusMap.filter(s => s.parentId === item.ID).length > 0) {
      //       this.level[filtable.ID] = (this.level[filtable.ID] || 0) + 1;
      //       this.levelParents[levelFiltable.child.ID] = item.ID;
      //       this.checkItem();
      //       return;
      //     }
      //   }

      //   let mostTop = false;
      //   if (!item.ID) {
      //     /// 点击不限
      //     if (levelFiltable.ancestor) {
      //       const parent = filtable.linkChain.find(ll => ll.ID === levelFiltable.ancestor);
      //       /// 选择上一级
      //       const statusMap = getStatusMap(parent, {
      //         users: this.redux.cuser.data, departments: this.redux.department.data, statusMap: this.filter.statusMap
      //       });
      //       items = statusMap.filter(s => s.ID === this.levelParents[levelFiltable.ID]);
      //       item = items[0];
      //       levelFiltable = parent;
      //     } else {
      //       mostTop = true;
      //     }
      //   }

      //   if (mostTop) {
      //     this.clearFilter(filtable);
      //   } else {
      //     if (filtable.multi) {
      //       /// 获取本级
      //       const filter = this.getFilterValue(levelFiltable);
      //       items = unionBy(items, filter, 'ID');
      //       /// 清除本级以下的
      //       let tempItems = [item];
      //       let temp = levelFiltable.child;
      //       while (temp) {
      //         const statusMap = getStatusMap(temp, {
      //           users: this.redux.cuser.data, departments: this.redux.department.data, statusMap: this.filter.statusMap
      //         });
      //         const children = statusMap.filter(s => tempItems.find(t => t.ID === s.parentId));
      //         const filter = this.getFilterValue(temp);
      //         this.filted = this.filted.merge({ [temp.ID]: filter.filter(s => !children.find(c => c.ID === s.ID)) })
      //         tempItems = children;
      //         temp = temp.child;
      //       }
      //       /// 清除本级以上的
      //       let tempItem = item;
      //       if (levelFiltable.ancestor) {
      //         temp = filtable.linkChain.find(ll => ll.ID === levelFiltable.ancestor);
      //       }
      //       while (temp) {
      //         const statusMap = getStatusMap(temp, {
      //           users: this.redux.cuser.data, departments: this.redux.department.data, statusMap: this.filter.statusMap
      //         });
      //         const parItem = statusMap.find(s => s.ID === tempItem.parentId);
      //         const filter = this.getFilterValue(temp);
      //         this.filted = this.filted.merge({ [temp.ID]: filter.filter(s => s.ID !== parItem.ID) })
      //         tempItem = parItem;
      //         if (temp.ancestor) {
      //           temp = filtable.linkChain.find(ll => ll.ID === temp.ancestor);
      //         } else {
      //           temp = null;
      //         }
      //       }
      //       this.checkItem()
      //     } else {
      //       /// 清除所有
      //       this.clearFilter(filtable);
      //     }
      //   }
      // }

      // if (!filtable.multi) {
      //   this.history[filtable.ID] = unionBy(items.map(i => Object.assign({ history: true, filtableID: filtable.ID, levelFiltableID: levelFiltable.ID }, i)), this.history[filtable.ID], 'ID').slice(0, 4);
      // }
      // this.filted = this.filted.merge({ [levelFiltable.ID]: items })
      // if (this.coms.list.checkType === 'radio') {
      //   this.handleConfirm();
      // } else {
      //   this.checkItem()
      // }
    },
    checkItem() {
      if (this.visible && this.filter.filtable) {
        if (this.type === 'filter' || this.type === 'extra') {
          if (this.initSelect) {
            this.initSelect = false;
            this.index = this.filter.filtable.findIndex(f => f.ID === this.ID || (f.linkChain && f.linkChain.find(l => l.ID === this.ID)));
          }
          const single = this.setSingleList(this.index, null, true);
          const filtable = this.filter.filtable[this.index];

          let items = single.items[0].items.map(i => Object.assign({}, i, { classChecked: 'b b-ecstasy', primaryClassChecked: 'text-primary' }));

          const gitems = [];

          const checkType = filtable.multi || (filtable.linkChain && filtable.linkChain.find(l => l.multi)) ? 'check' : 'radio';

          if (checkType === 'check') {
            let selected = [];
            if (filtable.linkChain) {
              filtable.linkChain.forEach(l => {
                const filt = this.getFilterValue(l).map(i => Object.assign({ classChecked: 'b b-ecstasy', primaryClassChecked: 'text-primary', checked: true, selected: true, filtableID: filtable.ID, levelFiltableID: l.ID }, i));
                selected = filt.concat(selected);
              });
            } else {
              const filt = this.getFilterValue(filtable).map(i => Object.assign({ classChecked: 'b b-ecstasy', primaryClassChecked: 'text-primary', checked: true, selected: true, filtableID: filtable.ID, levelFiltableID: filtable.ID }, i));
              selected = filt;
            }

            gitems.push({
              class: 'm-b-sm',
              header: {
                type: 'header2',
                class: 'padder padder-v-sm bg-white',
                title: `已选`,
                subTitle: selected.length > 0 ? '清空' : '',
                subClass: 'text-primary text-sm',
                subButton: selected.length > 0 ? 'clear' : ''
              },
              type: 'tag-label',
              columnCount: 4,
              items: selected
            });
          } else {
            gitems.push({
              class: 'm-b-sm',
              header: {
                type: 'header2',
                class: 'padder padder-v-sm bg-white',
                title: `历史`
              },
              type: 'tag-label',
              columnCount: 4,
              items: (this.history[filtable.ID] || []).map((h, index) => Object.assign({}, h, { classChecked: 'b b-ecstasy', primaryClassChecked: 'text-primary', checked: index === 0 }))
            });
          }

          gitems.push({
            header: {
              type: 'header2',
              class: 'padder padder-v-sm bg-white',
              title: `选择:`,
              subTitle: this.level[filtable.ID] > 0 ? '返回上一级' : '',
              subClass: 'text-primary text-sm',
              subButton: this.level[filtable.ID] > 0 ? { id: 'upLevel', filtableID: filtable.ID } : ''
            },
            type: 'tag-label',
            columnCount: 4,
            class: 'b-t',
            items
          });

          this.setData({
            checkType
          });
          this.coms.list.setCheckType(checkType);
          this.coms.list.alpha = false;
          this.coms.list.updateItems(gitems);
        } else if (this.type === 'sort') {
          this.setData({
            checkType: 'radio'
          });
          this.coms.list.setCheckType('radio');
          this.coms.list.alpha = false;
          const items = []
          this.sortable.forEach(s => {
            if (s.checked) {
              items.push(Object.assign({}, s, { primaryCheckClass: 'flex text-center text-primary', primaryClass: `flex text-center`, primaryText: `${s.primaryText} 低-高`, orderBy: 1, checked: s.orderBy === 1 }))
              items.push(Object.assign({}, s, { primaryCheckClass: 'flex text-center text-primary', primaryClass: `flex text-center`, primaryText: `${s.primaryText} 高-低`, orderBy: 2, checked: s.orderBy === 2 }))
            } else {
              items.push(Object.assign({}, s, { primaryCheckClass: 'flex text-center text-primary', primaryClass: 'flex text-center', primaryText: `${s.primaryText} 低-高`, orderBy: 1 }))
              items.push(Object.assign({}, s, { primaryCheckClass: 'flex text-center text-primary', primaryClass: 'flex text-center', primaryText: `${s.primaryText} 高-低`, orderBy: 2 }))
            }
          })
          this.coms.list.updateItems([
            {
              type: 'list-item-n',
              class: 'b-t',
              items: items
            }
          ]);
        } else if (this.type === 'more') {
          const gitems = [];

          for (let ii = 0; ii < this.filtable.length; ii += 1) {
            const filtable = this.filtable[ii];

            const single = this.setSingleList(filtable, null, true);

            let item;
            if (filtable.pTypeId === 1) {
              item = Object.assign({}, filtable, single.items[0], {
                items: [{
                  columns: [
                    {
                      noLabel: true,
                      editType: 'filter-switch',
                      eid: `__c${filtable.ID}`,
                      ID: filtable.ID,
                      property: {},
                      primaryText: filtable.primaryText
                    }
                  ],
                  uncheckable: true,
                  columnCount: 1,
                  [`__c${filtable.ID}`]: single.items[0].items[0].checked
                }]
              });
            } else {
              const items = single.items[0].items.map(i => Object.assign({}, i, { type: 'group-button', classChecked: 'b b-ecstasy bg-ecstasy', primaryClassChecked: 'text-primary' }));

              item = Object.assign({
                checkType: single.checkType, header: {
                  type: 'header2',
                  class: 'padder padder-v-sm bg-white',
                  title: `${single.items[0].tag} ${filtable.multi ? '(可多选)' : ''}`,
                  subTitle: this.level[filtable.ID] > 0 ? '返回上一级' : '',
                  subClass: 'text-primary text-sm',
                  subButton: this.level[filtable.ID] > 0 ? { id: 'upLevel', filtableID: filtable.ID } : ''
                }
              }, filtable, single.items[0], { items, type: 'tabAsList', className: 'padder-sm' });
            }
            gitems.push(item);
          }

          this.coms.list.setCheckType('check');
          this.coms.list.alpha = false;
          this.coms.list.updateItems(gitems);
        } else if (this.type === 'more2') {
          this.coms.list.setCheckType('radio');
          this.coms.list.alpha = false;
          this.coms.list.updateItems([{ items: this.filtable.map((item, index) => Object.assign({}, item, { class: 'b-b bg-light', classChecked: 'b-b bg-white', checked: index === this.listIndex, selected: this.filted[item.ID] && (this.filted[item.ID].length > 1 || (this.filted[item.ID].length === 1 && this.filted[item.ID][0].ID)) })) }]);

          const listCount = this.filtable[this.listIndex].link.length
          if (!this.indexes) {
            this.indexes = Array(listCount).fill(0)
          }
          this.setData({
            listCount
          })
          let parentId = null
          this.filtable[this.listIndex].link.forEach((l, index) => {
            const isLast = index === listCount - 1
            const single = this.setSingleList(l, parentId, isLast, this.indexes[index], isLast ? { type: 'list-item-n' } : { type: 'list-check-bg', class: 'bg-white', classChecked: 'bg-white', primaryClassChecked: 'text-primary' })
            const items = single.items[0].items;

            const item = Object.assign({
              checkType: single.checkType
            }, single.items[0], { items });

            this.coms[`list${index}`].updateItems([item])
            this.coms[`list${index}`].setCheckType(single.checkType);
            parentId = items[this.indexes[index]].ID
          })

        }
      }
    }
  }
]);
