import config from '../../config/config';
import fetchListMixin from '../../module/fetchListMixin';
import initFilter from '../../module/initFilter';
import Component from '../../components/component';
import list from '../list/list';
import mixin from '../../utils/mixin';
import panel from '../panel';
import searchbar from '../searchbar/searchbar';
import { updateFilter } from '../../redux/filter';
import unionBy from '../../lib/lodash/unionBy';
import immutable from '../../lib/seamless-immutable/src/seamless-immutable';
import { getStatusMap } from '../../utils/utils';

const regeneratorRuntime = require('../../lib/regenerator-runtime/runtime');

export default mixin(panel, [{
  level: {},
  reduxState: ['cuser', 'department'],
  components: {
    list: {
      component: list,
      options() {
        return {
          data: {
            itemType: 'list-item'
          },
          deselectable: true,
          pageId: -1
        };
      }
    }
  },
  showChainPicker(scope, data) {

    this.setHidden('', ()=>{
      this.setData({
        returnScope: scope
      });
      this.data = data;

      this.editData = {};
      data.column.linkChain.forEach(l => {
        this.editData[l.ID] = this.data.editData[`${l.eid}___Orgin`] ? this.data.editData[`${l.eid}___Orgin`].slice() : []
      });
      // this.changePosition('top');

      this.history = {};
      this.level = {};
      this.levelParents = {};

      this.show();
      this.checkItem();
    });
  },
  clearFilter() {
    this.editData = {};
    this.checkItem();
  },
  handleButtonEvent(scope, button, item, gindex, index) {
    if (button  === 'clear') {
      this.clearFilter();
    } else if (button.id === 'upLevel') {
      this.level[button.filtableID] --;
      this.checkItem();
    }
  },
  onLoad() {

    console.log('xxzzzzzzz');

    this.on('checkable-tap', this.checkableTap);
    this.on('showChainPicker', this.showChainPicker);
    this.on('buttonClick', this.handleButtonEvent);
  },
  showPanelPicker(scope, checkType, items) {
  },
  setSingleList() {
    let filtable = this.data.column;

    filtable = this.getLevel(filtable);

    const checkType = filtable.multi ? 'check' : 'radio';
    const filt = this.getFilterValue(filtable);
    const eid = `__c${filtable.ID}`;
    const filtableID = filtable.ID;

    const  statusMap = getStatusMap(filtable, {
      users: this.redux.cuser.data, departments: this.redux.department.data, statusMap: this.data.statusMap
    });
    let items = (filtable.filter && statusMap ? statusMap.filter(filtable.filter) : statusMap) || [];

    if (this.levelParents[filtable.ID]) {
      items = items.filter(i => i.parentId === this.levelParents[filtable.ID]);
    }

    let itemProp = { columnCount: 4 };

    items = items.map(i => Object.assign({ eid, filtableID, useCheckIcon: true, checkIconClass: 'text-lg text-primary font-thin', uncheckIconClass: 'text-lg text-muted font-thin', checked: filt.find(f => f.ID === i.ID) }, i, itemProp));


    items = immutable([{
      type: 'tag-label',
      primaryText: '全部',
      class:'',
      columnCount: 4,
      eid,
      filtableID,
      checked: filt.find(f => typeof f.ID === 'undefined')
    }]).concat(items);

    return {
      checkType,
      items: [{ tag: filtable.primaryText,
        items,
        pTypeId: filtable.pTypeId
      }]
    };
  },
  getLevel(filtable) {
    let temp = filtable;
    let level = this.level[filtable.ID];
    while(level && temp && temp.child) {
      temp = temp.child;
      level --;
    }
    return temp;
  },
  getFilterValue(filtable) {
    return this.editData[filtable.ID] || [];
  },
  methods: {
    handleConfirm() {
      this.hide();
      for(let ii = this.data.column.linkChain.length - 1; ii > 0; ii --) {
        const ll = this.data.column.linkChain[ii];
        const parent = this.data.column.linkChain[ii -1];
        const data = this.editData[ll.ID] || [];
        const parentIds = unionBy(data, 'parentId').map(i => i.parentId);

        const  statusMap = getStatusMap(parent, {
          users: this.redux.cuser.data, departments: this.redux.department.data, statusMap: this.data.statusMap
        });
        this.editData[parent.ID] = unionBy(this.editData[parent.ID] || [], statusMap.filter(s => parentIds.find(p => p === s.ID)));
      }

      this.emit('chainPickerReturn', this.page, this.getData().returnScope, Object.assign({}, this.data, { editData: this.editData }));
    }
  },
  dealWithAll(items, indexs) {
    // 当前点击区域的数据
    items = items.filter(i => i.indexes[0] === indexs[0]);
    if (items.length > 1) {
      // 包含全部项
      const all = items.find(i => typeof i.ID === 'undefined');
      if (all) {
        // 点击的就是全部项
        if (all.indexes[0] === indexs[0] && all.indexes[1] === indexs[1]) {
          items = [all];
        } else if (items.find(i => i.indexes[1] === indexs[1])) {
          items = items.filter(i => typeof i.ID !== 'undefined');
        }
      }
    }
    return items;
  },
  setEditData(id, items) {
    items = items.filter(i => typeof i.ID !== 'undefined');
    this.editData[id] = items;
  },
  itemTaped(items, indexs, item) {
    const filtable = this.data.column;
    let levelFiltable = this.getLevel(filtable);
    // 单选历史
    if (item.history) {
      if (filtable.linkChain) {
        this.editData = {};
        this.level[filtable.ID] = filtable.linkChain.findIndex(l => l.ID === item.levelFiltableID);
      }

      this.setEditData(item.levelFiltableID, [item]);
      this.history[filtable.ID] = [item].concat(this.history[filtable.ID].filter(i => i.ID !== item.ID));

      this.handleConfirm();
      return;
    }

    // 多选已选
    if (item.selected) {
      const filter = this.getFilterValue({ ID: item.levelFiltableID });
      this.setEditData(item.levelFiltableID, filter.filter(f => f.ID !== item.ID));
      return;
    }

    items = this.dealWithAll(items, indexs);
    /// 多级数据
    if (filtable.linkChain) {
      /// 点击的不是全部，而且当前level有子节点
      if (item.ID && levelFiltable.child) {
        const statusMap = getStatusMap(levelFiltable.child, {
          users: this.redux.cuser.data, departments: this.redux.department.data, statusMap: this.data.statusMap
        });
        if (statusMap.filter(s => s.parentId === item.ID).length > 0) {
          this.level[filtable.ID] = (this.level[filtable.ID] || 0) + 1;
          this.levelParents[levelFiltable.child.ID] = item.ID;
          this.checkItem();
          return;
        }
      }

      let mostTop = false;
      if (!item.ID) {
        /// 点击全部
        if (levelFiltable.ancestor) {
          const parent = filtable.linkChain.find(ll => ll.ID === levelFiltable.ancestor );
          const  statusMap = getStatusMap(parent, {
            users: this.redux.cuser.data, departments: this.redux.department.data, statusMap: this.data.statusMap
          });
          /// 选择上一级
          items = statusMap.filter(s => s.ID === this.levelParents[levelFiltable.ID]);
          item = items[0];
          levelFiltable = parent;
        } else {
          mostTop = true;
        }
      }

      if (mostTop) {
        this.clearFilter();
      } else {
        if (filtable.multi) {
          /// 获取本级
          const filter = this.getFilterValue(levelFiltable);
          items = unionBy(items, filter, 'ID');
          /// 清除本级以下的
          let tempItems = [item];
          let temp = levelFiltable.child;
          while(temp) {
            const  statusMap = getStatusMap(temp, {
              users: this.redux.cuser.data, departments: this.redux.department.data, statusMap: this.data.statusMap
            });
            const children = statusMap.filter(s => tempItems.find(t => t.ID === s.parentId));
            const filter = this.getFilterValue(temp);
            this.editData[temp.ID] = filter.filter(s => !children.find(c => c.ID === s.ID));
            tempItems = children;
            temp = temp.child;
          }
          /// 清除本级以上的
          let tempItem = item;
          if (levelFiltable.ancestor) {
            temp = filtable.linkChain.find(ll => ll.ID === levelFiltable.ancestor );
          }
          while(temp) {
            const  statusMap = getStatusMap(temp, {
              users: this.redux.cuser.data, departments: this.redux.department.data, statusMap: this.data.statusMap
            });
            const parItem = statusMap.find(s => s.ID === tempItem.parentId);
            const filter = this.getFilterValue(temp);
            this.editData[temp.ID] = filter.filter(s => s.ID !== parItem.ID);
            tempItem = parItem;
            if (temp.ancestor) {
              temp = filtable.linkChain.find(ll => ll.ID === temp.ancestor );
            } else {
              temp = null;
            }
          }
        } else {
          /// 清除所有
          this.clearFilter();
        }
      }
    }

    if (!filtable.multi) {
      this.history[filtable.ID] = unionBy(items.map(i => Object.assign({ history: true, filtableID: filtable.ID, levelFiltableID: levelFiltable.ID }, i)), this.history[filtable.ID], 'ID').slice(0, 4);
    }

    this.setEditData(levelFiltable.ID, items);
    if (this.coms.list.checkType === 'radio') {
      this.handleConfirm();
    }
  },
  checkableTap(scope, items, indexs, item) {
    const childScope = this.getChildEventScope(scope);
    if (childScope === 'list'){
      // console.log(items, indexs, item);
      this.itemTaped(items, indexs, item);
    }
  },
  checkItem() {
    if (this.visible) {
      const single = this.setSingleList();
      const filtable = this.data.column;

      let items = single.items[0].items.map(i => Object.assign({}, i, { classChecked: 'b b-ecstasy', primaryCheckedClass: 'text-primary' }));

      const gitems = [];

      const checkType = filtable.multi || (filtable.linkChain && filtable.linkChain.find(l => l.multi)) ? 'check' : 'radio';

      if (checkType === 'check') {
        let selected = [];
        if (filtable.linkChain) {
          filtable.linkChain.forEach(l => {
            const filt = this.getFilterValue(l).map(i => Object.assign({ classChecked: 'b b-ecstasy', primaryCheckedClass: 'text-primary', checked: true, selected: true, filtableID: filtable.ID, levelFiltableID: l.ID }, i));
            selected = filt.concat(selected);
          });
        } else {
          const filt = this.getFilterValue(filtable).map(i => Object.assign({ classChecked: 'b b-ecstasy', primaryCheckedClass: 'text-primary', checked: true, selected: true, filtableID: filtable.ID, levelFiltableID: filtable.ID }, i));
          selected = filt;
        }

        gitems.push({
          class: 'm-b-sm',
          header: {
            type: 'header2',
            class: 'padder padder-v-sm bg-white',
            title: `已选`,
            subTitle: selected.length > 0 ? '清空' : '',
            subClass: 'text-primary text-sm',
            subButton: selected.length > 0 ? 'clear' : ''
          },
          type: 'tag-label',
          columnCount: 4,
          items: selected
        });
      } else {
        gitems.push({
          class: 'm-b-sm',
          header: {
            type: 'header2',
            class: 'padder padder-v-sm bg-white',
            title: `历史`
          },
          type: 'tag-label',
          columnCount: 4,
          items: (this.history[filtable.ID] || []).map((h, index) => Object.assign({}, h, { classChecked: 'b b-ecstasy', primaryCheckedClass: 'text-primary', checked: index === 0 }))
        });
      }

      gitems.push({
        header: {
          type: 'header2',
          class: 'padder padder-v-sm bg-white',
          title: `选择:`,
          subTitle: this.level[filtable.ID] > 0 ? '返回上一级' : '',
          subClass: 'text-primary text-sm',
          subButton: this.level[filtable.ID] > 0 ? { id: 'upLevel', filtableID: filtable.ID } : ''
        },
        type: 'tag-label',
        columnCount: 4,
        class: 'b-t',
        items
      });

      this.setData({
        checkType
      });
      this.coms.list.setCheckType(checkType);
      this.coms.list.alpha = false;
      this.coms.list.updateItems(gitems);
    }
  }
}]);
