import Component from '../../components/component';
import { fixSub } from '../../utils/utils';
import mixin from '../../utils/mixin';

export default mixin(Component, [
  {
    data: {
      backdrop: false,
      buttons: [],
      hbuttons: [],
      visible: true,
      className: 'speed-dial-bottom-right'
    },
    position: 'bottomRight',
    opened: false,
    types: [
      {
        type: 'topLeft',
        className: 'speed-dial-top-left',
      },
      {
        type: 'topRight',
        className: 'speed-dial-top-right',
      },
      {
        type: 'bottomLeft',
        className: 'speed-dial-bottom-left',
      },
      {
        type: 'bottomRight',
        className: 'speed-dial-bottom-right',
      }
    ],
    methods: {
      handleToggle() {
        this.toggle();
      },
      handleButtonClicked(e) {
        const index = e.currentTarget.dataset.index;
        const data = this.getData();
        if (this.buttonClicked && this.buttonClicked(data.buttons[index]) === true) {
          this.toggle(false);
        }
      },
      handleHButtonClicked(e) {
        const index = e.currentTarget.dataset.index;
        const data = this.getData();
        if (this.buttonClicked && this.buttonClicked(data.hbuttons[index]) === true) {
          this.toggle(false);
        }
      },
    },
    setButtons(allButtons) {
      if (allButtons.buttons.length + allButtons.hbuttons.length === 1) {
        this.setData({
          buttons: [],
          hbuttons: [],
          oneButton: allButtons.buttons[0] || allButtons.hbuttons[0]
        });
      } else {
        this.setData({
          buttons: allButtons.buttons,
          hbuttons: allButtons.hbuttons,
          oneButton: null
        });
      }
    },
    toggle(opened) {
      const data = this.getData();
      if (data.oneButton) {
        this.buttonClicked && this.buttonClicked(data.oneButton);
        return;
      }
      if (typeof opened === 'undefined') {
        opened = !this.opened;
      }
      this.setData({
        opened
      });
      this.opened = opened;
      this.callback && this.callback(opened);
    },
    onLoad(options) {
      this.setData({
        className: fixSub(this.types.find(item => item.type === this.position).className, this.className, ' ')
      });
    }
  }
]);
