import Component from '../../components/component';
import mixin from '../../utils/mixin';
import { login } from '../../redux/login';
import config from '../../config/config';

export default mixin(Component, [
    {
        data: {
            visible: false,
            url: ''
        },
        defaultShowCss() {
            return {
                main: 'zoomIn',
                back: 'fadeIn'
            };
        },
        defaultHideCss() {
            return {
                main: 'zoomOut',
                back: 'fadeIn'
            };
        },
        methods: {
            handleOutTap(e) {
                this.setHidden();
                console.log(e);
                this.cancel && this.cancel(e.detail.formId);
            },
            handleTap(e) {
                this.setHidden();
                console.log(e);
                this.callback && this.callback(e.detail.formId);
            }
        },
        handleShow(scope, params) {
            this.callback = params.callback;
            this.cancel = params.cancel;
            this.setData({
                url: params.url
            });
            this.setVisible();
        },
        onLoad() {
            this.on('showAdvise', this.handleShow);
        }
    }
]);
