import config from '../../config/config';
import editColumnMixin from '../../module/editColumnMixin';
import editMixin from '../../module/editMixin';
import fetchDetailMixin from '../../module/fetchDetailMixin';
import filterMixin from '../../module/filterMixin';
import log from '../../utils/log';
import mixin from '../../utils/mixin';
import panelpicker from '../panelpicker/panelpicker';

export default mixin(panelpicker, [fetchDetailMixin,
  filterMixin,
  editColumnMixin,
  editMixin,
  {
    useFetch: false,
    pageId: -1,
    quickAdd: true,
    onLoad(options) {
      this.on('showQuickAdd', this.showQuickAdd);
    },
    showPanelPicker(scope, checkType, items) {
    },
    showQuickAdd(scope, pageId, param) {
      const createPageId = config.router[pageId].createPageId;
      this.pageId = createPageId;
      this.item = param;
      this.fetchDetail(true);
      this.redux.initFilter({ pageId: this.getOption('pageId')});
      this.show();
    },
    reduxState: ['filter'],
    filter: {},
    updateRedux({ filter }) {
      const pageId = this.getOption('pageId');
      const theFilter = filter[pageId];
      if (theFilter && theFilter.display && theFilter !== this.filter) {
        log('当前字段信息', pageId, theFilter);
        this.filter = theFilter;
        this.setData({
          columns: this.filter.display.filter(item => config.router[pageId].quickAddColumns.findIndex(a => a === item.ID) >= 0)
        });
      }
    },
    afterUpdate() {
      this.emit('quickAddReturn', this.page);
      this.hide();
    }
  }]);
