import Component from '../../components/component';
import mixin from '../../utils/mixin';

export default mixin(Component, [{
  data: {
    stars: [],
    cutIndex: -1,
    cutPercent: 0,
    value: 0,
    star: 'fa fa-star', // '♡','★', '☼' '☻'
    disabled: false,
    text: [],
    activeClass: 'text-primary',
    inActiveClass: 'text-muted'
  },
  max: 5,
  methods: {
    handleClick(e) {
      const i = e.currentTarget.dataset.index + 1;
      const data = this.getData();

      if (data.disabled) {
        return;
      }

      this.updateValues(data.value === i ? i - 1 : i);
    }
  },
  updateValues(value = 0, noTrigger) {
    // this.page.clearDataTimer();
    const _val = Number(value);
    value = _val < 0 ? 0 : _val > this.max ? this.max : _val;
    this.setData({
      value
    });

    this.updateValue(value);

    // this.page.setDataTimer();

    !noTrigger && this.callback && this.callback(value);
  },
  updateMax() {
    const stars = [];
    for (let i = 0; i < this.max; i += 1) {
      stars.push(i);
    }
    this.setData({
      stars
    });
  },
  updateValue(value) {
    const _val = value.toString().split('.');
    const sliceValue = _val.length === 1 ? [_val[0], 0] : _val;
    this.setData({
      cutIndex: sliceValue[0]*1,
      cutPercent: `0.${sliceValue[1]}` * 100
    });
  },
  onReady() {
    this.updateMax();
  }
}]);
