import Component from '../../components/component';
import mixin from '../../utils/mixin';
import switchVisibleByTouchDirectionMixin from '../../module/switchVisibleByTouchDirectionMixin';

export default mixin(Component, [
  {
    data: {
      placeholder: '请输入关键词'
    },
    defaultShowCss: 'fadeInTop',
    defaultHideCss: 'fadeOutTop',
    methods: {
      handleSearchInputChanged(e) {
        this.searchInputChanged && this.searchInputChanged(e.detail.value);
      },
      back(){
        this.realBack();
      },
      setValue(e){
        this.setData({
          searchInput: e.detail.value
        });
      },
      handleFocus(e) {
        this.setData({
          focus: true
        });
      },
      handleBlur(e) {
        this.setData({
          focus: false
        });
      },
      handleCancel(e) {
        
      }
    },
    realBack() {
      wx.navigateBack();
    },
    onLoad(){
      this.setData({
        hasMorePage: getCurrentPages().length > 1
      });
    }
  }
]);
