// import { confirmFilter, updateFilter, updateSingleFilter } from '../../redux/filter';

import Tab from '../tab/tab';
import log from '../../utils/log';
import mixin from '../../utils/mixin';

export default mixin(Tab, [
  {
    // reduxDispatch: { updateSingleFilter, confirmFilter },
    tabChanged(scope, item, selected, toggle) {
      if (this.scope === scope) {
        log(scope, item, selected, this.column);
        if (this.listview) {
          this.listview.setFixedLsc(selected ? { patternId: this.column.ID, pTypeId: this.column.pTypeId, operation: 1, val1: item.ID } : []);
          this.listview.refresh();
        }
        // this.redux.updateSingleFilter({ pageId: this.getOption('pageId'), index: this.index, items: selected ? [item] : [] });
        // this.redux.confirmFilter({ pageId: this.getOption('pageId') });
      }
    },
    onLoad(options) {
      this.on('tabChanged', this.tabChanged);
    },
    setColumn(column, index, scroll = false) {
      this.column = column;
      this.index = index;
      this.setData({
        scroll,
        list: column.statusMap.map((item) => {
          return Object.assign({ id: item.ID, title: item.primaryText, toggle: true }, item);
        })
      });
    },
    setFilter(index) {
      this.setData({
        selectedId: index
      });
      if (index === -1) {
        this.tabChanged(this.scope, null, false);
      } else {
        const item = this.column.statusMap[index];
        this.tabChanged(this.scope, item, true);
      }
    }
  }
]);
