import Component from '../../components/component';
import mixin from '../../utils/mixin';

export default mixin(Component, [
  {
    data: {
      scroll: false,
      fixed: false,
      height: 0,
      list: [],
      selectedId: -1
    },
    selectIndex(index) {
      const data = this.getData();

      if (data.selectedId !== index) {
        this.emit('tabChanged', this.page, data.list[index], true, false, index);
        if (!data.list[index].deselect) {
          this.setDelayData({
            selectedId: index
          });
        }
      } else {


        if (data.list[index].toggle) {
          this.setData({
            selectedId: -1
          });
          this.emit('tabChanged', this.page, data.list[index], false, index);
        } else {
          this.emit('tabChanged', this.page, data.list[index], true, true, index);
        }
      }
    },
    methods: {
      handleTabChanged(e) {
        const { index } = e.currentTarget.dataset;
        this.selectIndex(index);
      }
    }
  }
]);
