import { confirmFilter, updateFilter, updateSingleFilter, updateSort } from '../../redux/filter';

import component from '../../components/component';
import filterMixin from '../../module/filterMixin';
import filterpanelMixin from '../../module/filtpanelMixin';
import list from '../list/list';
import log from '../../utils/log';
import mixin from '../../utils/mixin';
import puresearchbar from '../searchbar/puresearchbar';
import { searchbar } from '../polaris';
import { getStatusMap } from '../../utils/utils';

export default mixin(component, [
    filterMixin,
    filterpanelMixin,
    {
        data: {
            height: 0,
            windowHeight: 0,
            hideFilter: false
        },
        type: 'more',
        refreshColumns: true,
        isPanel: false,
        windowHeight: 0,
        defaultShowCss: 'fadeInDown',
        defaultHideCss: 'fadeOutUp',
        components: {
            list: {
                component: list,
                options(owner) {
                    return {
                        data: {
                            itemType: 'list-item'
                        },
                        deselectable: true,
                        pageId: -1,
                        customDataChanged: owner.customDataChanged.bind(owner)
                    };
                }
            },
            list2: {
                component: list,
                options() {
                    return {
                        pageId: -1
                    };
                }
            }
        },
        methods: {
            handleShowFilter(e) {
                !this.visible && this.showFilter(true);
            },
            handleScroll(e) {
                if (e.detail.deltaY < 0 && e.detail.scrollTop >= 50 && this.visible) {
                    this.showFilter(false);
                }
                if (e.detail.deltaY < 0 && e.detail.scrollTop <= -20) {
                    this.callback && this.callback();
                }
            },
            handleScrollToUpper(e) {
                !this.visible && this.showFilter(true);
            },
            handleFilterAll(e) {
                this.emit('filtManager', this.page, { type: 'more' });
            }
        },
        handleButtonEvent(scope, button, item, gindex, index) {
            if (button === 'showFilterAll') {
                this.emit('filtManager', this.page, { type: 'more' });
            }
        },
        onLoad() {
            this.on('checkable-tap', this.checkableTap);
            this.on('buttonClick', this.handleButtonEvent);
            wx.getSystemInfo({
                success: (res) => {
                    this.windowHeight = res.windowHeight;
                    this.rpx2px = res.windowWidth / 750.0;
                }
            });
        },
        filtFilter(filter) {
            const newFiler = Object.assign({}, filter);
            newFiler.filtable = filter.filtable
                .filter(
                    (i) =>
                        i.editType === 'status' ||
                        i.editType === 'mstatus' ||
                        i.editType === 'user' ||
                        i.editType === 'users'
                )
                .slice(0, 4);
            //  newFiler.filtable = newFiler.filtable.slice(0,4);
            return newFiler;
        },
        showFilter(show) {
            const filtable = this.filter.filtable || [];
            this.setData({
                height: (show ? (filtable.length + 1) * 80 : 80) * this.rpx2px,
                windowHeight: this.windowHeight
            });
            if (show) {
                this.setVisible();
                this.setData({
                    displayCss: 'fadeOut'
                });
                this.setDelayData({
                    hideFilter: false
                });
            } else {
                this.setHidden();
                this.setData({
                    hideFilter: true,
                    displayCss: 'fadeIn'
                });
            }
        },
        checkItem() {
            if (this.filter.filtable) {
                const items = [];
                const checkItems = [];

                const tagConfig = {
                    noFixWidth: true,
                    type: 'tag-label',
                    classChecked: 'bg-black r-2000',
                    class: 'bg-white',
                    primaryClass: 'text-black'
                };

                for (let ii = 0; ii < this.filter.filtable.length; ii += 1) {
                    const filtable = this.filter.filtable[ii];
                    const filt = (this.filter.filter && this.filter.filter[filtable.ID]) || [];
                    const eid = `__c${filtable.ID}`;
                    const statusMap = getStatusMap(filtable, {
                        users: this.redux.cuser.data,
                        departments: this.redux.department.data,
                        statusMap: this.filter.statusMap
                    });
                    let filtitems =
                        (filtable.filter && statusMap ? statusMap.filter(filtable.filter) : statusMap) || [];
                    filtitems = filtitems.map((i) => Object.assign({ checked: filt.find((f) => f.ID === i.ID) }, i));

                    items.push({
                        type: 'scrollAsList',
                        checkType: filtable.multi ? 'check' : 'radio',
                        class: 'b-b',
                        pre: {
                            type: 'grid',
                            label: filtable.primaryText,
                            labelClass: 'text-muted',
                            class: 'w-20-b padder-v-sm'
                        },
                        items: filtitems.map((i) => Object.assign({ eid }, i, tagConfig)),
                        footer:
                            ii === this.filter.filtable.length - 1
                                ? {
                                      type: 'header2',
                                      class: 'b-b bg-white',
                                      title: '全部筛选',
                                      titleClass: 'font-bold',
                                      icon2: 'fa fa-angle-right',
                                      iconClass2: 'font-bold m-l-xs',
                                      mainCenter: true,
                                      button: 'showFilterAll'
                                  }
                                : null
                    });

                    const cc = filtitems
                        .filter((i) => i.checked)
                        .map((i) => Object.assign({ uncheckable: true, eid }, i, tagConfig));
                    checkItems.push(...cc);
                }

                if (checkItems.length < 1) {
                    checkItems.push(
                        Object.assign(
                            {
                                primaryText: '所有服装',
                                checked: true,
                                uncheckable: true
                            },
                            tagConfig
                        )
                    );
                }

                this.coms.list.updateItems(items);
                this.coms.list2.updateItems([
                    {
                        items: checkItems,
                        type: 'scrollAsList',
                        class: 'b-b',
                        sub: {
                            type: 'grid',
                            icon: 'fa fa-angle-down',
                            class: 'padder',
                            noNav: true
                        }
                    }
                ]);
                this.showFilter(this.visible);
            }
        }
    }
]);
