import Tab from '../tab/tab';
import mixin from '../../utils/mixin';

export default mixin(Tab, [{
  data: {
    selectedId: 0
  },
  tabChanged(scope, item, toggle, oldIndex, index) {
    if (this.scope === scope && this.getTab) {
      const oldTab = this.getTab(oldIndex);
      const newTab = this.getTab(index);
      let oldCss = oldIndex < index ? 'slideOutLeft' : 'slideOutRight';
      let newCss = oldIndex < index ? 'slideInRight' : 'slideInLeft';

      oldTab.setHidden(oldCss);
      newTab.setVisible(newCss);
    }
  },
  onLoad(options) {
    this.on('tabChanged', this.tabChanged);
  }
}]);
