import Component from '../../components/component';
import mixin from '../../utils/mixin';

export default mixin(Component, [
  {
    timer: 2000,
    data: {
      visible: false,
    },
    defaultShowCss: 'slideInDown',
    defaultHideCss: 'slideOutUp',
    hide() {
      if (this.setHidden()) {
        if (this.timeout) {
          clearTimeout(this.timeout);
          this.timeout = null;
        }
        this.callback && this.callback();
      }
    },
    show() {
      if (this.setVisible()) {
        this.timeout = setTimeout(this.hide.bind(this), this.timer);
      }
    },
    showToptip(scope, opts) {
      this.setData(opts);
      this.show();
    },
    onLoad(options) {
      this.on('showToptip', this.showToptip);
    }
  }
]);
