import createAction from '../lib/redux-actions/lib/createAction';
import handleActions from '../lib/redux-actions/lib/handleActions';
import immutable from '../lib/seamless-immutable/src/seamless-immutable';

export const FETCH_CACHE = 'FETCH_CACHE';
export const FETCH_CACHE_SUCCESS = 'FETCH_CACHE_SUCCESS';
export const FETCH_CACHE_FAILURE = 'FETCH_CACHE_FAILURE';
export const INIT_CACHE = 'INIT_CACHE';

export const fetchCache = createAction(FETCH_CACHE);
export const fetchCacheSuccess = createAction(FETCH_CACHE_SUCCESS);
export const fetchCacheFailure = createAction(FETCH_CACHE_FAILURE);
export const initCache = createAction(INIT_CACHE);
// 初始state
export const INITIAL_STATE = immutable(
    {
        // pageId: 0,
        // fetching: false,
        // error: null,
        // data: {},
        // itemId: 0
    }
);

export default handleActions(
    {
        [FETCH_CACHE]: (state, { payload }) =>
            state.merge({
                [payload.configPageId || payload.pageId]: (state[payload.configPageId || payload.pageId] ||
                    immutable({}))
                    .merge({ fetching: true, error: null })
            }),
        [FETCH_CACHE_SUCCESS]: (state, { payload }) => {
            if (state[payload.pageId]) {
                return state.set(
                    payload.pageId,
                    state[payload.pageId].merge({
                        fetching: false,
                        error: null,
                        data: payload.data
                    })
                );
            }
            return state;
        },
        [FETCH_CACHE_FAILURE]: (state, { payload }) =>
            state.set(payload.pageId, state[payload.pageId].merge({ fetching: false, error: payload.error })),
        [INIT_CACHE]: () => INITIAL_STATE
    },
    INITIAL_STATE
);
