import config from '../config/config';
// import { createAction, handleActions } from 'redux-actions';
import createAction from '../lib/redux-actions/lib/createAction';
import handleActions from '../lib/redux-actions/lib/handleActions';
import immutable from '../lib/seamless-immutable/src/seamless-immutable';

export const COLUMN = 'COLUMN';
export const INIT_COLUMN = 'INIT_COLUMN';

export const column = createAction(COLUMN);
export const initColumn = createAction(INIT_COLUMN);
// 初始state
export const INITIAL_STATE = immutable({
});

export default handleActions({
  [COLUMN]: (state, { payload }) => state.merge({
    [payload.pageId]: {
      cacheTime: payload.cacheTime,
      data: payload.data
    }
  }),
  [INIT_COLUMN]: () => INITIAL_STATE
}, INITIAL_STATE);
